/*
 * Decompiled with CFR 0.152.
 */
package com.podio.app;

import com.podio.BaseAPI;
import com.podio.ResourceFactory;
import com.podio.app.Application;
import com.podio.app.ApplicationCreate;
import com.podio.app.ApplicationCreateResponse;
import com.podio.app.ApplicationField;
import com.podio.app.ApplicationFieldConfiguration;
import com.podio.app.ApplicationFieldCreate;
import com.podio.app.ApplicationFieldCreateResponse;
import com.podio.app.ApplicationInstall;
import com.podio.app.ApplicationUpdate;
import com.podio.app.Dependencies;
import com.podio.common.Empty;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.MediaType;
import java.util.HashMap;
import java.util.List;

public class AppAPI
extends BaseAPI {
    public AppAPI(ResourceFactory resourceFactory) {
        super(resourceFactory);
    }

    public Application getApp(long appId) {
        return (Application)this.getResourceFactory().getApiResource("/app/" + appId).get(Application.class);
    }

    public List<Application> getAppsOnSpace(int spaceId) {
        return (List)this.getResourceFactory().getApiResource("/app/space/" + spaceId + "/").get((GenericType)new GenericType<List<Application>>(){});
    }

    public List<Application> getTopApps(Integer limit) {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (limit != null) {
            queryParams.put("limit", limit.toString());
        }
        Invocation.Builder resource = this.getResourceFactory().getApiResource("/app/top/", queryParams);
        return (List)resource.get((GenericType)new GenericType<List<Application>>(){});
    }

    public long addApp(ApplicationCreate app) {
        return ((ApplicationCreateResponse)this.getResourceFactory().getApiResource("/app/").post(Entity.entity((Object)app, (MediaType)MediaType.APPLICATION_JSON_TYPE), ApplicationCreateResponse.class)).getId();
    }

    public void updateApp(long appId, ApplicationUpdate app) {
        this.getResourceFactory().getApiResource("/app/" + appId).put(Entity.entity((Object)app, (String)"application/json"));
    }

    public long addField(long appId, ApplicationFieldCreate field) {
        return ((ApplicationFieldCreateResponse)this.getResourceFactory().getApiResource("/app/" + appId + "/field/").post(Entity.entity((Object)field, (MediaType)MediaType.APPLICATION_JSON_TYPE), ApplicationFieldCreateResponse.class)).getId();
    }

    public void updateField(long appId, int fieldId, ApplicationFieldConfiguration configuration) {
        this.getResourceFactory().getApiResource("/app/" + appId + "/field/" + fieldId).put(Entity.entity((Object)configuration, (MediaType)MediaType.APPLICATION_JSON_TYPE));
    }

    public ApplicationField getField(long appId, int fieldId) {
        return (ApplicationField)this.getResourceFactory().getApiResource("/app/" + appId + "/field/" + fieldId).get(ApplicationField.class);
    }

    public ApplicationField getField(long appId, String externalId) {
        return (ApplicationField)this.getResourceFactory().getApiResource("/app/" + appId + "/field/" + externalId).get(ApplicationField.class);
    }

    public void deleteField(long appId, int fieldId) {
        this.getResourceFactory().getApiResource("/app/" + appId + "/field/" + fieldId).delete();
    }

    public long install(long appId, int spaceId) {
        return ((ApplicationCreateResponse)this.getResourceFactory().getApiResource("/app/" + appId + "/install").post(Entity.entity((Object)new ApplicationInstall(spaceId), (MediaType)MediaType.APPLICATION_JSON_TYPE), ApplicationCreateResponse.class)).getId();
    }

    public void updateOrder(int spaceId, List<Integer> appIds) {
        this.getResourceFactory().getApiResource("/app/space/" + spaceId + "/order").put(Entity.entity(appIds, (MediaType)MediaType.APPLICATION_JSON_TYPE));
    }

    public List<Application> getApps() {
        return (List)this.getResourceFactory().getApiResource("/app/v2/").get((GenericType)new GenericType<List<Application>>(){});
    }

    public Dependencies getDependencies(long appId) {
        return (Dependencies)this.getResourceFactory().getApiResource("/app/" + appId + "/dependencies/").get(Dependencies.class);
    }

    public void deactivateApp(long appId) {
        this.getResourceFactory().getApiResource("/app/" + appId + "/deactivate").post(Entity.entity((Object)new Empty(), (MediaType)MediaType.APPLICATION_JSON_TYPE));
    }

    public void activateApp(long appId) {
        this.getResourceFactory().getApiResource("/app/" + appId + "/activate").post(Entity.entity((Object)new Empty(), (MediaType)MediaType.APPLICATION_JSON_TYPE));
    }

    public void deleteApp(long appId) {
        this.getResourceFactory().getApiResource("/app/" + appId).delete();
    }
}

