/*
 * Decompiled with CFR 0.152.
 */
package com.podio;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.jakarta.rs.json.JacksonJsonProvider;
import com.podio.AuthProvider;
import com.podio.CustomJacksonJsonProvider;
import com.podio.DryRunFilter;
import com.podio.ExceptionFilter;
import com.podio.RateLimitFilter;
import com.podio.oauth.OAuthClientCredentials;
import com.podio.oauth.OAuthUserCredentials;
import com.podio.serialize.DateTimeDeserializer;
import com.podio.serialize.DateTimeSerializer;
import com.podio.serialize.LocalDateDeserializer;
import com.podio.serialize.LocalDateSerializer;
import com.podio.serialize.LocaleDeserializer;
import com.podio.serialize.LocaleSerializer;
import com.podio.serialize.TimeZoneDeserializer;
import com.podio.serialize.TimeZoneSerializer;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.WebTarget;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.glassfish.jersey.client.filter.EncodingFilter;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.glassfish.jersey.message.GZipEncoder;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ResourceFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceFactory.class);
    private final WebTarget apiResource;
    private final WebTarget fileResource;
    private final AuthProvider authProvider;

    public ResourceFactory(OAuthClientCredentials clientCredentials, OAuthUserCredentials userCredentials) {
        this("api.podio.com", "files.podio.com", 443, true, false, clientCredentials, userCredentials);
    }

    public ResourceFactory(String apiHostname, String fileHostname, int port, boolean ssl, boolean dryRun, OAuthClientCredentials clientCredentials, OAuthUserCredentials userCredentials) {
        this(ResourceFactory.createDefaultClient(dryRun), apiHostname, fileHostname, port, ssl, clientCredentials, userCredentials);
    }

    public ResourceFactory(Client client, String apiHostname, String fileHostname, int port, boolean ssl, OAuthClientCredentials clientCredentials, OAuthUserCredentials userCredentials) {
        this.apiResource = client.target(this.getURI(apiHostname, port, ssl));
        this.fileResource = client.target(this.getURI(fileHostname, port, ssl));
        this.authProvider = new AuthProvider(this, clientCredentials, userCredentials);
    }

    private URI getURI(String hostname, int port, boolean ssl) {
        try {
            return new URI(ssl ? "https" : "http", null, hostname, port, null, null, null);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private static Client createDefaultClient(boolean dryRun) {
        ClientBuilder clientBuilder = ClientBuilder.newBuilder();
        if (dryRun) {
            clientBuilder.register(DryRunFilter.class);
        }
        return ((ClientBuilder)((ClientBuilder)((ClientBuilder)((ClientBuilder)((ClientBuilder)((ClientBuilder)((ClientBuilder)((ClientBuilder)((ClientBuilder)clientBuilder.connectTimeout(10L, TimeUnit.SECONDS).readTimeout(100L, TimeUnit.SECONDS).register(MultiPartFeature.class)).register(GZipEncoder.class)).register(EncodingFilter.class)).register(ExceptionFilter.class)).register((Object)ResourceFactory.getJsonProvider())).register(RateLimitFilter.class)).register(requestContext -> requestContext.getHeaders().putSingle((Object)"User-Agent", (Object)"Podio Java API Client"))).register(requestContext -> LOG.debug("request {} {} {}", new Object[]{requestContext.getMethod(), requestContext.getUri(), requestContext.getEntity()}))).register((requestContext, responseContext) -> LOG.debug("response {} {}: {} {}", new Object[]{requestContext.getMethod(), requestContext.getUri(), responseContext.getStatus(), responseContext.getStatusInfo() != null ? responseContext.getStatusInfo().getReasonPhrase() : null}))).build();
    }

    public static JacksonJsonProvider getJsonProvider() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        mapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        SimpleModule module = new SimpleModule();
        module.addSerializer(DateTime.class, (JsonSerializer)new DateTimeSerializer());
        module.addSerializer(LocalDate.class, (JsonSerializer)new LocalDateSerializer());
        module.addSerializer(TimeZone.class, (JsonSerializer)new TimeZoneSerializer());
        module.addSerializer(Locale.class, (JsonSerializer)new LocaleSerializer());
        module.addDeserializer(DateTime.class, (JsonDeserializer)new DateTimeDeserializer());
        module.addDeserializer(LocalDate.class, (JsonDeserializer)new LocalDateDeserializer());
        module.addDeserializer(TimeZone.class, (JsonDeserializer)new TimeZoneDeserializer());
        module.addDeserializer(Locale.class, (JsonDeserializer)new LocaleDeserializer());
        mapper.registerModule((Module)module);
        return new CustomJacksonJsonProvider(mapper);
    }

    public Invocation.Builder getFileResource(String path) {
        return this.getFileResource(path, true);
    }

    public Invocation.Builder getFileResource(String path, boolean secure) {
        WebTarget subResource = this.fileResource.path(path);
        Invocation.Builder requestBuilder = subResource.request();
        if (secure) {
            requestBuilder.header("Authorization", (Object)("OAuth2 " + this.authProvider.getToken().getAccessToken()));
        }
        return requestBuilder;
    }

    public Invocation.Builder getApiResource(String path) {
        return this.getApiResource(path, true);
    }

    public Invocation.Builder getApiResource(String path, Map<String, String> queryParams) {
        return this.getApiResource(path, true, queryParams);
    }

    public Invocation.Builder getApiResource(String path, boolean secure) {
        return this.getApiResource(path, secure, Collections.emptyMap());
    }

    public Invocation.Builder getApiResource(String path, boolean secure, Map<String, String> queryParams) {
        WebTarget subResource = this.apiResource.path(path);
        for (Map.Entry<String, String> entry : queryParams.entrySet()) {
            subResource = subResource.queryParam(entry.getKey(), new Object[]{entry.getValue()});
        }
        Invocation.Builder requestBuilder = subResource.request();
        if (secure) {
            requestBuilder.header("Authorization", (Object)("OAuth2 " + this.authProvider.getToken().getAccessToken()));
        }
        return requestBuilder;
    }
}

