/*
 * Decompiled with CFR 0.152.
 */
package com.podio;

import com.podio.RateLimits;
import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.ClientResponseContext;
import jakarta.ws.rs.client.ClientResponseFilter;

public class RateLimitFilter
implements ClientResponseFilter {
    public void filter(ClientRequestContext requestContext, ClientResponseContext responseContext) {
        String rateLimitLimit = responseContext.getHeaderString("X-Rate-Limit-Limit");
        String rateLimitRemaining = responseContext.getHeaderString("X-Rate-Limit-Remaining");
        if (rateLimitLimit != null) {
            try {
                RateLimits.setLimit(Integer.parseInt(rateLimitLimit));
            }
            catch (NumberFormatException nfe) {
                RateLimits.setLimit(null);
            }
        } else {
            RateLimits.setLimit(null);
        }
        if (rateLimitRemaining != null) {
            try {
                RateLimits.setRemaining(Integer.parseInt(rateLimitRemaining));
            }
            catch (NumberFormatException nfe) {
                RateLimits.setRemaining(null);
            }
        } else {
            RateLimits.setRemaining(null);
        }
    }
}

