/*
 * Decompiled with CFR 0.152.
 */
package com.podio;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.podio.APIApplicationException;
import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.ClientResponseContext;
import jakarta.ws.rs.client.ClientResponseFilter;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class ExceptionFilter
implements ClientResponseFilter {
    public void filter(ClientRequestContext requestContext, ClientResponseContext responseContext) throws IOException {
        if (responseContext.getStatusInfo() == null || responseContext.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            if (responseContext.hasEntity()) {
                Map errorData = (Map)new ObjectMapper().readValue(responseContext.getEntityStream(), Map.class);
                throw new APIApplicationException(responseContext.getStatusInfo(), (String)errorData.get("error"), (String)errorData.get("error_description"), (Map)errorData.get("parameters"));
            }
            throw new APIApplicationException(responseContext.getStatusInfo(), "unknown error", "empty response", new HashMap<String, String>());
        }
    }
}

