/*
 * Decompiled with CFR 0.152.
 */
package com.podio;

import com.podio.ResourceFactory;
import com.podio.oauth.OAuthAPI;
import com.podio.oauth.OAuthClientCredentials;
import com.podio.oauth.OAuthRefreshTokenCredentials;
import com.podio.oauth.OAuthToken;
import com.podio.oauth.OAuthUserCredentials;

public class AuthProvider {
    private final OAuthClientCredentials clientCredentials;
    private final OAuthUserCredentials userCredentials;
    private final OAuthAPI oauthAPI;
    private OAuthToken token;
    private long expireTime;

    public AuthProvider(ResourceFactory baseAPI, OAuthClientCredentials clientCredentials, OAuthUserCredentials userCredentials) {
        this.clientCredentials = clientCredentials;
        this.userCredentials = userCredentials;
        this.oauthAPI = new OAuthAPI(baseAPI);
    }

    private void updateToken(OAuthUserCredentials credentials) {
        this.token = this.oauthAPI.getToken(this.clientCredentials, credentials);
        this.expireTime = System.currentTimeMillis() + (long)(this.token.getExpiresIn() * 1000);
    }

    private void newToken() {
        this.updateToken(this.userCredentials);
    }

    private void refreshToken() {
        this.updateToken(new OAuthRefreshTokenCredentials(this.token.getRefreshToken()));
    }

    public synchronized OAuthToken getToken() {
        if (this.token == null) {
            this.newToken();
        } else if (this.expireTime < System.currentTimeMillis() - 30000L) {
            this.refreshToken();
        }
        return this.token;
    }
}

