/*
 * Decompiled with CFR 0.152.
 */
package com.github.podal.codejavadoc.mojo;

import com.github.podal.codejavadoc.CodeJavaDoc;
import com.github.podal.codejavadoc.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

public class CodeJavaDocMvn
extends AbstractMojo {
    public void execute() throws MojoExecutionException {
        try {
            ArrayList list = new ArrayList();
            MavenProject project = this.getProject();
            list.addAll(project.getCompileSourceRoots());
            list.addAll(project.getTestCompileSourceRoots());
            ArrayList<File> fileList = new ArrayList<File>();
            for (String fileName : list) {
                File file = new File(fileName);
                if (!file.exists() || !file.isDirectory()) continue;
                fileList.add(file);
            }
            if (!fileList.isEmpty()) {
                File tmpFile = new File(project.getBasedir() + "/target/codeToJavaDoc");
                if (!tmpFile.exists() && !tmpFile.mkdirs()) {
                    throw new MojoExecutionException("Can't create dir " + tmpFile);
                }
                final String encoding = (String)project.getProperties().get("project.build.sourceEncoding");
                if (encoding == null) {
                    this.getLog().error((CharSequence)"Must set project.build.sourceEncoding");
                    throw new MojoExecutionException("Must set project.build.sourceEncoding");
                }
                CodeJavaDoc.doCodeToJavaDoc((File[])fileList.toArray(new File[0]), (FileUtil.Encoding)new FileUtil.Encoding(){

                    public String getEncoding(File file) {
                        return encoding;
                    }
                }, (File)tmpFile, (CodeJavaDoc.Log)new CodeJavaDoc.Log(){

                    public void log(String line) {
                        CodeJavaDocMvn.this.getLog().debug((CharSequence)line);
                    }
                });
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error execute", (Exception)e);
        }
    }

    public MavenProject getProject() {
        return (MavenProject)this.getPluginContext().get("project");
    }
}

