/*
 * Decompiled with CFR 0.152.
 */
package async.net.impl;

import async.net.RemoteControl;
import async.net.callback.ExceptionCallback;
import async.net.callback.IOCallback;
import async.net.impl.IOUtil;
import async.net.impl.ListenOnRunAccept;
import async.net.socket.ServerSocket;
import async.net.socket.Socket;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;

public class ListenOnRun
implements Runnable,
RemoteControl {
    private ServerSocket serverSocket;
    private IOCallback ioCallback;
    private ExecutorService executorService;
    private ExceptionCallback<IOException> eCallback;
    private AtomicBoolean active = new AtomicBoolean(true);

    public ListenOnRun(ExecutorService executorService, ServerSocket serverSocket, IOCallback ioCallback, ExceptionCallback<IOException> eCallback) {
        this.executorService = executorService;
        this.serverSocket = serverSocket;
        this.ioCallback = ioCallback;
        this.eCallback = eCallback;
    }

    @Override
    public void run() {
        block3: {
            try {
                while (this.active.get()) {
                    Socket socket = this.serverSocket.accept();
                    ListenOnRunAccept accept = new ListenOnRunAccept(socket, this.ioCallback, this.eCallback);
                    this.executorService.execute(accept);
                }
            }
            catch (IOException e) {
                if (this.eCallback == null) break block3;
                this.eCallback.exception((Throwable)e);
            }
        }
        this.active.set(false);
    }

    public boolean isActive() {
        return this.active.get();
    }

    public void stop() {
        IOUtil.close(this.serverSocket, this.eCallback);
        this.active.set(false);
    }
}

