/*
 * Decompiled with CFR 0.152.
 */
package async.net.http.impl;

import async.net.http.impl.DefaulHttpResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class HttpResponseOutputStream
extends OutputStream {
    private DefaulHttpResponse response;
    private OutputStream out;
    private ByteArrayOutputStream stream = new ByteArrayOutputStream();
    private boolean flush = false;
    private boolean close = false;
    private boolean started = false;

    public HttpResponseOutputStream(DefaulHttpResponse response, OutputStream out) {
        this.response = response;
        this.out = out;
    }

    @Override
    public void write(int b) throws IOException {
        this.checkClose();
        this.started = true;
        if (this.flush) {
            this.out.write(b);
        } else {
            this.stream.write(b);
        }
    }

    @Override
    public void write(byte[] bs, int s, int l) throws IOException {
        this.checkClose();
        this.started = true;
        if (this.flush) {
            this.out.write(bs, s, l);
        } else {
            this.stream.write(bs, s, l);
        }
    }

    @Override
    public void flush() throws IOException {
        this.checkClose();
        this.started = true;
        if (!this.flush) {
            this.out.write(this.response.getHead());
            this.out.write(this.stream.toByteArray());
            this.stream = null;
            this.flush = true;
        }
    }

    private void checkClose() throws IOException {
        if (this.close) {
            throw new IOException("Alredy closed");
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.close) {
            if (!this.flush) {
                this.response.setHeader("Content-Length", Integer.toString(this.stream.size()));
            }
            this.flush();
            this.close = true;
        }
    }

    public boolean isFlush() {
        return this.flush;
    }

    public boolean isStarted() {
        return this.started;
    }
}

