/*
 * Decompiled with CFR 0.152.
 */
package async.net.http.impl;

import async.net.http.HTTPType;
import async.net.http.HttpRequest;
import async.net.http.impl.HttpError;
import async.net.impl.FixedInputStream;
import async.net.impl.IOUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class DefaultHttpRequest
implements HttpRequest {
    private static final Map<Integer, List<String>> END_HEADER = new HashMap<Integer, List<String>>();
    private static final int MAX_HEADER_LENGTH = 10240;
    private InputStream stream;
    private HTTPType type;
    private String url;
    private Map<String, String> headers;
    private String queryString;
    private OutputStream outStream;

    public DefaultHttpRequest(InputStream stream) throws IOException, HttpError {
        this.stream = stream;
        this.parseStart(this.stream);
    }

    private void parseStart(InputStream stream2) throws IOException, HttpError {
        int i;
        ArrayList<String> headers = new ArrayList<String>();
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        int last = 0;
        int newLineSize = 0;
        int pos = 0;
        while ((i = stream2.read()) != -1) {
            stream.write(i);
            if (i == 10 || i == 13) {
                ++newLineSize;
                String string = stream.toString();
                String h = string.substring(last, pos).trim();
                if (!h.isEmpty()) {
                    headers.add(h);
                }
                if (END_HEADER.containsKey(newLineSize)) {
                    String end = string.substring(string.length() - newLineSize);
                    if (END_HEADER.get(newLineSize).contains(end)) break;
                }
                last = pos;
            } else {
                newLineSize = 0;
            }
            if (pos >= 10240) {
                throw new HttpError();
            }
            ++pos;
        }
        this.parseFiretLine(headers);
        this.parseHeaders(headers);
    }

    private void parseHeaders(List<String> headers) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (int j = 1; j < headers.size(); ++j) {
            String string = headers.get(j);
            String[] strings = string.split(": ", 2);
            if (strings.length == 1) {
                map.put(string, "");
                continue;
            }
            map.put(strings[0], strings[1]);
        }
        this.headers = Collections.unmodifiableMap(map);
    }

    private void parseFiretLine(List<String> headers) throws HttpError {
        String[] s = headers.get(0).split(" ");
        if (s.length != 3) {
            throw new HttpError();
        }
        this.type = HTTPType.getType((String)s[0]);
        this.url = s[1];
        int q = s[1].indexOf(63);
        if (q != -1) {
            this.url = s[1].substring(0, q);
            this.queryString = s[1].substring(q + 1);
        }
    }

    public HTTPType getType() {
        return this.type;
    }

    public String getPath() {
        return this.url;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public void setOutputStream(OutputStream outStream) {
        this.outStream = outStream;
    }

    public void flush() throws IOException {
        String contentLength = this.getHeaders().get("Content-Length");
        if (contentLength != null) {
            this.stream = new FixedInputStream(this.stream, Integer.parseInt(contentLength));
        }
        if (this.outStream != null) {
            IOUtil.copy(this.stream, this.outStream);
            this.outStream.close();
        }
    }

    static {
        END_HEADER.put(2, new ArrayList<String>(Arrays.asList("\n\n", "\r\r")));
        END_HEADER.put(4, new ArrayList<String>(Arrays.asList("\n\r\n\r", "\r\n\r\n")));
    }
}

