/*
 * Decompiled with CFR 0.152.
 */
package async.net.impl;

import java.io.IOException;
import java.io.InputStream;

public class FixedInputStream
extends InputStream {
    private InputStream stream;
    private int size;
    private int count = 0;

    public FixedInputStream(InputStream stream, int size) {
        this.stream = stream;
        this.size = size;
    }

    @Override
    public int read() throws IOException {
        if (this.count < this.size) {
            int i = this.stream.read();
            ++this.count;
            return i;
        }
        return -1;
    }

    @Override
    public int read(byte[] bs, int start, int length) throws IOException {
        if (this.count < this.size) {
            int i = this.stream.read(bs, start, Math.min(length, this.size - this.count));
            this.count += i;
            return i;
        }
        return -1;
    }
}

