/*
 * Decompiled with CFR 0.152.
 */
package async.net.impl;

import async.net.callback.Dispatcher;
import async.net.callback.ExitCallback;
import async.net.callback.IOCallback;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DefaultDispatcher
implements Dispatcher {
    private Set<OutputStream> streams = new HashSet<OutputStream>();

    public IOCallback createCallback() {
        return this.createCallback(null);
    }

    public IOCallback createCallback(final ExitCallback exitCallback) {
        return new IOCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void call(InputStream in, OutputStream out) throws IOException {
                try {
                    int i;
                    DefaultDispatcher.this.addStream(out);
                    byte[] bs = new byte[1024];
                    while ((i = in.read(bs)) != -1) {
                        DefaultDispatcher.this.write(bs, 0, i, out);
                    }
                }
                finally {
                    if (exitCallback != null) {
                        exitCallback.onExit();
                    }
                    DefaultDispatcher.this.removeStream(out);
                }
            }
        };
    }

    protected synchronized void removeStream(OutputStream stream) {
        this.streams.remove(stream);
    }

    protected synchronized void write(byte[] bs, int i, int i2, OutputStream ... excludeStreams) throws IOException {
        List<OutputStream> excludeStreamsAsList = Arrays.asList(excludeStreams);
        for (OutputStream stream : this.streams) {
            if (excludeStreamsAsList.contains(stream)) continue;
            stream.write(bs, i, i2);
            stream.flush();
        }
    }

    private synchronized void addStream(OutputStream stream) {
        this.streams.add(stream);
    }

    public IOCallback createFactory() {
        return new IOCallback(){

            public void call(InputStream in, OutputStream out) throws IOException {
                DefaultDispatcher.this.createCallback().call(in, out);
            }
        };
    }
}

