/*
 * Decompiled with CFR 0.152.
 */
package async.net.impl;

import async.net.ASyncSocket;
import async.net.ASyncType;
import async.net.RemoteControl;
import async.net.callback.ExceptionCallback;
import async.net.callback.IOCallback;
import async.net.impl.ConncetToRun;
import async.net.impl.ListenOnRun;
import async.net.socket.ServerSocket;
import async.net.socket.SocketFactory;
import async.net.socket.impl.DefaultSocketFactory;
import async.net.thread.ThreadHandler;
import java.io.IOException;
import java.net.InetAddress;
import java.util.concurrent.ExecutorService;

public class DefaultASyncSocket
implements ASyncSocket {
    private ThreadHandler handler;
    private SocketFactory socketFactory = new DefaultSocketFactory();
    private ExceptionCallback<IOException> exceptionCallback;
    private InetAddress address;

    public DefaultASyncSocket(ThreadHandler handler, InetAddress address, ExceptionCallback<IOException> exceptionCallback) {
        this.handler = handler;
        this.exceptionCallback = exceptionCallback;
        this.address = address;
    }

    public RemoteControl listenOn(int port, IOCallback ioCallback) throws IOException {
        ExecutorService executorService = this.handler.getExecutorService(ASyncType.SOCKET_LISTEN);
        ExecutorService executorServiceConnect = this.handler.getExecutorService(ASyncType.SOCKET_LISTEN_CONNECT);
        ServerSocket serverSocket = this.socketFactory.createServerSocket(port, this.address);
        ListenOnRun listenOnRun = new ListenOnRun(executorServiceConnect, serverSocket, ioCallback, this.exceptionCallback);
        executorService.execute(listenOnRun);
        return listenOnRun;
    }

    public void connectTo(String host, int port, IOCallback callback) throws IOException {
        ExecutorService executorService = this.handler.getExecutorService(ASyncType.SOCKET_CONNECT);
        executorService.execute(new ConncetToRun(this.socketFactory.createSocket(host, port), callback, this.exceptionCallback));
    }
}

