/*
 * Decompiled with CFR 0.152.
 */
package async.net.http.impl;

import async.net.http.ASyncWriter;
import async.net.http.HttpResponse;
import async.net.http.impl.DefalultASyncWriter;
import async.net.http.impl.HttpResponseOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;

public class DefaulHttpResponse
implements HttpResponse {
    private static final char[] NEW_LINE = new char[]{'\r', '\n'};
    private OutputStream out;
    private int code = 200;
    protected HttpResponseOutputStream responseOut;
    private Map<String, String> headers = new HashMap<String, String>();
    private DefalultASyncWriter writer;
    private String encoding = "ISO-8859-1";

    public DefaulHttpResponse(OutputStream out) {
        this.out = out;
        this.headers.put("Content-Type", "text/plain");
    }

    public void setReturnCode(int code) {
        this.code = code;
    }

    public OutputStream getOutputStream() {
        if (this.responseOut == null) {
            this.responseOut = new HttpResponseOutputStream(this, this.out);
        }
        return this.responseOut;
    }

    public byte[] getHead() throws IOException {
        if (this.code == -1) {
            throw new IOException("Return code isn't set.");
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        PrintWriter writer = new PrintWriter(stream);
        writer.print("HTTP/1.0 ");
        writer.print(this.code);
        writer.print(NEW_LINE);
        for (Map.Entry<String, String> en : this.headers.entrySet()) {
            writer.print(en.getKey());
            writer.print(": ");
            writer.print(en.getValue());
            writer.print(NEW_LINE);
        }
        writer.print(NEW_LINE);
        writer.flush();
        return stream.toByteArray();
    }

    public void setHeader(String key, String value) {
        this.headers.put(key, value);
    }

    public void close() throws IOException {
        if (this.writer != null) {
            this.writer.flush();
        }
        if (this.responseOut != null) {
            this.responseOut.close();
        }
    }

    public boolean isFlush() {
        if (this.responseOut != null) {
            return this.responseOut.isFlush();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendError() throws IOException {
        this.setReturnCode(500);
        OutputStream out = this.getOutputStream();
        try {
            out.write("Error 500".getBytes());
        }
        finally {
            out.close();
        }
    }

    public ASyncWriter getWriter() {
        if (this.writer == null) {
            this.writer = new DefalultASyncWriter(this.getOutputStream(), this.encoding);
        }
        return this.writer;
    }

    public void sendRedirect(String url) {
        if (this.isFlush() || this.responseOut != null && this.responseOut.isStarted() || this.writer != null && this.writer.isStaerted()) {
            throw new IllegalStateException("Can't use 'sendRedirect' when started a stream/writer.");
        }
        this.setHeader("Location", url);
        this.setReturnCode(302);
    }

    public void flush() throws IOException {
        if (!this.isFlush()) {
            this.getOutputStream().flush();
        }
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }
}

