/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema.pagination;

import com.google.gson.Gson;
import graphql.language.StringValue;
import graphql.schema.Coercing;
import graphql.schema.CoercingSerializeException;
import graphql.schema.GraphQLScalarType;
import graphql.schema.pagination.Identifiable;
import graphql.schema.pagination.Page;
import java.nio.charset.Charset;
import java.util.Base64;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\u000e\b\u0001\u0010\u0003*\b\u0012\u0004\u0012\u0002H\u00010\u00042\u00020\u0005B\u001b\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00010\t\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lgraphql/schema/pagination/GraphQLPageCursor;", "T", "Lgraphql/schema/pagination/Identifiable;", "I", "Lgraphql/schema/pagination/Page$Info;", "Lgraphql/schema/GraphQLScalarType;", "name", "", "clazz", "Ljava/lang/Class;", "(Ljava/lang/String;Ljava/lang/Class;)V", "kotlin-gremlin-graphql"})
public final class GraphQLPageCursor<T extends Identifiable, I extends Page.Info<T>>
extends GraphQLScalarType {
    public GraphQLPageCursor(final @NotNull String name, final @NotNull Class<I> clazz) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        super(name, "A string allowing clients to resume pagination", new Coercing<I, String>(){
            private final Logger logger = LoggerFactory.getLogger(GraphQLPageCursor.class);
            private final Gson gson = new Gson();

            @NotNull
            public String serialize(@Nullable Object dataFetcherResult) {
                String string;
                Charset charset;
                Base64.Encoder encoder;
                Class<?> clazz3 = dataFetcherResult;
                if (clazz3 instanceof Page.Info) {
                    String jsonString = this.gson.toJson((Object)dataFetcherResult);
                    this.logger.debug("Serializing " + name + " as " + jsonString);
                    Base64.Encoder encoder2 = Base64.getEncoder();
                    String string2 = jsonString;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"jsonString");
                    String string3 = string2;
                    encoder = encoder2;
                    charset = Charsets.UTF_8;
                    string = string3;
                    if (string == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                } else {
                    Class<?> clazz2;
                    throw (Throwable)new CoercingSerializeException(name + " field cannot serialize '" + ((clazz2 = dataFetcherResult) != null && (clazz2 = clazz2.getClass()) != null ? clazz2.getSimpleName() : null) + "'.");
                }
                byte[] byArray = string.getBytes(charset);
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                byte[] byArray2 = byArray;
                String string4 = encoder.encodeToString(byArray2);
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"Base64.getEncoder().enco\u2026jsonString.toByteArray())");
                return string4;
            }

            @NotNull
            public I parseValue(@Nullable Object input) {
                String string;
                Charset charset;
                Base64.Decoder decoder;
                Object object;
                Class<?> clazz3 = input;
                if (clazz3 instanceof String) {
                    object = (String)((Object)input);
                    decoder = Base64.getDecoder();
                    charset = Charsets.UTF_8;
                    string = object;
                    if (string == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                } else {
                    Class<?> clazz2;
                    throw (Throwable)new CoercingSerializeException(name + " field cannot deserialize '" + ((clazz2 = input) != null && (clazz2 = clazz2.getClass()) != null ? clazz2.getSimpleName() : null) + "'.");
                }
                byte[] byArray = string.getBytes(charset);
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                byte[] byArray2 = byArray;
                byte[] byArray3 = decoder.decode(byArray2);
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray3, (String)"Base64.getDecoder().decode(input.toByteArray())");
                object = byArray3;
                String jsonString = new String((byte[])object, Charsets.UTF_8);
                this.logger.debug("Parsing (deserializing) " + name + " from " + jsonString);
                Object object2 = this.gson.fromJson(jsonString, clazz);
                Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"gson.fromJson(jsonString, clazz)");
                return (Page.Info)object2;
            }

            @NotNull
            public I parseLiteral(@Nullable Object input) {
                Class<?> clazz3 = input;
                if (!(clazz3 instanceof StringValue)) {
                    Class<?> clazz2;
                    throw (Throwable)new CoercingSerializeException(name + " field cannot deserialize '" + ((clazz2 = input) != null && (clazz2 = clazz2.getClass()) != null ? clazz2.getSimpleName() : null) + "'.");
                }
                return this.parseValue(((StringValue)input).getValue());
            }
        });
    }
}

