/*
 * Decompiled with CFR 0.152.
 */
package com.github.pires.hazelcast;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.hazelcast.config.Config;
import com.hazelcast.config.GroupConfig;
import com.hazelcast.config.JoinConfig;
import com.hazelcast.config.MulticastConfig;
import com.hazelcast.config.NetworkConfig;
import com.hazelcast.config.SSLConfig;
import com.hazelcast.config.TcpIpConfig;
import com.hazelcast.core.Hazelcast;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.CommandLineRunner;
import org.springframework.stereotype.Controller;

@Controller
public class HazelcastDiscoveryController
implements CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(HazelcastDiscoveryController.class);
    private static TrustManager[] trustAll = new TrustManager[]{new X509TrustManager(){

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }};
    private static HostnameVerifier trustAllHosts = new HostnameVerifier(){

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    };

    private static String getServiceAccountToken() throws IOException {
        String file = "/var/run/secrets/kubernetes.io/serviceaccount/token";
        return new String(Files.readAllBytes(Paths.get(file, new String[0])));
    }

    private static String getEnvOrDefault(String var, String def) {
        String val = System.getenv(var);
        return val == null || val.isEmpty() ? def : val;
    }

    public void run(String ... args) {
        String serviceName = HazelcastDiscoveryController.getEnvOrDefault("HAZELCAST_SERVICE", "hazelcast");
        String namespace = HazelcastDiscoveryController.getEnvOrDefault("POD_NAMESPACE", "default");
        String path = String.format("/api/v1/namespaces/%s/endpoints/", namespace);
        String domain = HazelcastDiscoveryController.getEnvOrDefault("DNS_DOMAIN", "cluster.local");
        String host = HazelcastDiscoveryController.getEnvOrDefault("KUBERNETES_MASTER", "https://kubernetes.default.svc.".concat(domain));
        log.info("Asking k8s registry at {}..", (Object)host);
        CopyOnWriteArrayList<String> hazelcastEndpoints = new CopyOnWriteArrayList<String>();
        try {
            String token = HazelcastDiscoveryController.getServiceAccountToken();
            SSLContext ctx = SSLContext.getInstance("SSL");
            ctx.init(null, trustAll, new SecureRandom());
            URL url = new URL(host + path + serviceName);
            HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
            conn.setSSLSocketFactory(ctx.getSocketFactory());
            conn.setHostnameVerifier(trustAllHosts);
            conn.addRequestProperty("Authorization", "Bearer " + token);
            ObjectMapper mapper = new ObjectMapper();
            Endpoints endpoints = (Endpoints)mapper.readValue(conn.getInputStream(), Endpoints.class);
            if (endpoints != null && endpoints.subsets != null && !endpoints.subsets.isEmpty()) {
                endpoints.subsets.parallelStream().forEach(subset -> subset.addresses.parallelStream().forEach(addr -> hazelcastEndpoints.add(addr.ip)));
            }
        }
        catch (IOException | KeyManagementException | NoSuchAlgorithmException ex) {
            log.warn("Request to Kubernetes API failed", (Throwable)ex);
        }
        log.info("Found {} pods running Hazelcast.", (Object)hazelcastEndpoints.size());
        this.runHazelcast(hazelcastEndpoints);
    }

    private void runHazelcast(List<String> nodes) {
        Config cfg = new Config();
        cfg.setInstanceName(UUID.randomUUID().toString());
        String HC_GROUP_NAME = HazelcastDiscoveryController.getEnvOrDefault("HC_GROUP_NAME", "someGroup");
        String HC_GROUP_PASSWORD = HazelcastDiscoveryController.getEnvOrDefault("HC_GROUP_PASSWORD", "someSecret");
        int HC_PORT = Integer.parseInt(HazelcastDiscoveryController.getEnvOrDefault("HC_PORT", "5701"));
        cfg.setGroupConfig(new GroupConfig(HC_GROUP_NAME, HC_GROUP_PASSWORD));
        NetworkConfig netCfg = new NetworkConfig();
        netCfg.setPortAutoIncrement(false);
        netCfg.setPort(HC_PORT);
        MulticastConfig mcCfg = new MulticastConfig();
        mcCfg.setEnabled(false);
        TcpIpConfig tcpCfg = new TcpIpConfig();
        nodes.parallelStream().forEach(arg_0 -> ((TcpIpConfig)tcpCfg).addMember(arg_0));
        tcpCfg.setEnabled(true);
        JoinConfig joinCfg = new JoinConfig();
        joinCfg.setMulticastConfig(mcCfg);
        joinCfg.setTcpIpConfig(tcpCfg);
        netCfg.setJoin(joinCfg);
        netCfg.setSSLConfig(new SSLConfig().setEnabled(false));
        cfg.setNetworkConfig(netCfg);
        Hazelcast.newHazelcastInstance((Config)cfg);
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static class Endpoints {
        public List<Subset> subsets;

        Endpoints() {
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static class Subset {
        public List<Address> addresses;

        Subset() {
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static class Address {
        public String ip;

        Address() {
        }
    }
}

