/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.bagging;

import org.apache.commons.math3.distribution.PoissonDistribution;
import org.apache.spark.SparkException;
import org.apache.spark.ml.bagging.BaggingPredictor;
import org.apache.spark.ml.bagging.BaggingPredictor$;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.SparseVector;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.util.BaggingMetadataUtils$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.bfunctions$;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.util.random.XORShiftRandom;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.util.Random;
import scala.util.Random$;

public abstract class BaggingPredictor$class {
    public static Column weightBag(BaggingPredictor $this, boolean withReplacement, double sampleRatio, int numberSamples, long seed) {
        return withReplacement ? functions$.MODULE$.array((Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numberSamples).map((Function1)new Serializable($this, sampleRatio, seed){
            public static final long serialVersionUID = 0L;
            private final double sampleRatio$1;
            private final long seed$1;

            public final Column apply(int iter) {
                return bfunctions$.MODULE$.poisson(this.sampleRatio$1, this.seed$1 + (long)iter);
            }
            {
                this.sampleRatio$1 = sampleRatio$1;
                this.seed$1 = seed$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())) : (sampleRatio == 1.0 ? functions$.MODULE$.array_repeat(functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)1)), numberSamples) : functions$.MODULE$.array((Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numberSamples).map((Function1)new Serializable($this, sampleRatio, seed){
            public static final long serialVersionUID = 0L;
            private final double sampleRatio$1;
            private final long seed$1;

            public final Column apply(int iter) {
                return functions$.MODULE$.expr(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"if(rand(", "+", ")<", ",1,0)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.seed$1), BoxesRunTime.boxToInteger((int)iter), BoxesRunTime.boxToDouble((double)this.sampleRatio$1)})));
            }
            {
                this.sampleRatio$1 = sampleRatio$1;
                this.seed$1 = seed$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())));
    }

    public static Column duplicateRow(BaggingPredictor $this, Column col) {
        return functions$.MODULE$.explode(functions$.MODULE$.array_repeat(functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)1)), col));
    }

    public static Seq arraySample(BaggingPredictor $this, boolean withReplacement, double sampleRatio, long seed, Seq array) {
        Seq seq;
        if (withReplacement) {
            PoissonDistribution poisson = new PoissonDistribution(sampleRatio);
            poisson.reseedRandomGenerator(seed);
            seq = (Seq)array.flatMap((Function1)new Serializable($this, poisson){
                public static final long serialVersionUID = 0L;
                private final PoissonDistribution poisson$1;

                public final Seq<Object> apply(double d) {
                    return this.poisson$1.sample() > 1 ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{d})) : (Seq)Seq$.MODULE$.empty();
                }
                {
                    this.poisson$1 = poisson$1;
                }
            }, Seq$.MODULE$.canBuildFrom());
        } else if (sampleRatio == 1.0) {
            seq = array;
        } else {
            XORShiftRandom rng = new XORShiftRandom(seed);
            seq = (Seq)array.flatMap((Function1)new Serializable($this, rng, sampleRatio){
                public static final long serialVersionUID = 0L;
                private final XORShiftRandom rng$1;
                private final double sampleRatio$2;

                public final Seq<Object> apply(double d) {
                    return this.rng$1.nextDouble() < this.sampleRatio$2 ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{d})) : (Seq)Seq$.MODULE$.empty();
                }
                {
                    this.rng$1 = rng$1;
                    this.sampleRatio$2 = sampleRatio$2;
                }
            }, Seq$.MODULE$.canBuildFrom());
        }
        return seq;
    }

    public static int[] arrayIndicesSample(BaggingPredictor $this, boolean withReplacement, int max, long seed, int[] array) {
        int[] nArray;
        int take = RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(max), array.length);
        if (withReplacement) {
            Random rand = new Random(seed);
            nArray = (int[])Predef$.MODULE$.intArrayOps((int[])Array$.MODULE$.fill(take, (Function0)new Serializable($this, rand, array){
                public static final long serialVersionUID = 0L;
                private final Random rand$1;
                private final int[] array$1;

                public final int apply() {
                    return this.apply$mcI$sp();
                }

                public int apply$mcI$sp() {
                    return this.rand$1.nextInt(this.array$1.length);
                }
                {
                    this.rand$1 = rand$1;
                    this.array$1 = array$1;
                }
            }, ClassTag$.MODULE$.Int())).distinct();
        } else {
            nArray = (int[])Predef$.MODULE$.intArrayOps(take == array.length ? array : (int[])Predef$.MODULE$.intArrayOps((int[])Random$.MODULE$.shuffle((TraversableOnce)Predef$.MODULE$.intArrayOps(array).indices().toIndexedSeq(), IndexedSeq$.MODULE$.canBuildFrom()).toArray(ClassTag$.MODULE$.Int())).take(take)).sorted((Ordering)Ordering.Int$.MODULE$);
        }
        return nArray;
    }

    public static Dataset withWeightedBag(BaggingPredictor $this, boolean withReplacement, double sampleRatio, int numberSamples, long seed, String outputColName, Dataset df) {
        return df.withColumn(outputColName, $this.weightBag(withReplacement, sampleRatio, numberSamples, seed));
    }

    public static Dataset withSampledRows(BaggingPredictor $this, String weightsColName, int index, Dataset df) {
        return df.withColumn("dummy", $this.duplicateRow(functions$.MODULE$.col(weightsColName).apply((Object)BoxesRunTime.boxToInteger((int)index)))).drop(functions$.MODULE$.col("dummy"));
    }

    public static Dataset withSampledFeatures(BaggingPredictor $this, String featuresColName, int[] indices, Dataset df) {
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(BaggingPredictor.class.getClassLoader());
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(BaggingPredictor.class.getClassLoader());
        public final class Org_apache_spark_ml_bagging_BaggingPredictor$$typecreator4$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
            }

            public Org_apache_spark_ml_bagging_BaggingPredictor$$typecreator4$1(BaggingPredictor $outer) {
            }
        }
        public final class Org_apache_spark_ml_bagging_BaggingPredictor$$typecreator5$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
            }

            public Org_apache_spark_ml_bagging_BaggingPredictor$$typecreator5$1(BaggingPredictor $outer) {
            }
        }
        UserDefinedFunction slicer = functions$.MODULE$.udf((Function1)new Serializable($this, indices){
            public static final long serialVersionUID = 0L;
            private final int[] indices$1;

            public final Vector apply(Vector vec) {
                Vector vector;
                block4: {
                    SparseVector sparseVector;
                    block3: {
                        block2: {
                            vector = vec;
                            if (!(vector instanceof DenseVector)) break block2;
                            DenseVector denseVector = (DenseVector)vector;
                            sparseVector = Vectors$.MODULE$.dense((double[])Predef$.MODULE$.intArrayOps(this.indices$1).map((Function1)new Serializable(this, denseVector){
                                public static final long serialVersionUID = 0L;
                                private final DenseVector x2$1;

                                public final double apply(int i) {
                                    return this.apply$mcDI$sp(i);
                                }

                                public double apply$mcDI$sp(int i) {
                                    return this.x2$1.apply(i);
                                }
                                {
                                    this.x2$1 = x2$1;
                                }
                            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())));
                            break block3;
                        }
                        if (!(vector instanceof SparseVector)) break block4;
                        SparseVector sparseVector2 = (SparseVector)vector;
                        sparseVector = sparseVector2.slice(this.indices$1);
                    }
                    return sparseVector;
                }
                throw new MatchError((Object)vector);
            }
            {
                this.indices$1 = indices$1;
            }
        }, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_bagging_BaggingPredictor$$typecreator4$1($this)), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_bagging_BaggingPredictor$$typecreator5$1($this)));
        return df.withColumn(featuresColName, slicer.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(featuresColName)})));
    }

    public static int getNumFeatures(BaggingPredictor $this, Dataset dataset, String featuresCol) {
        Option<Object> option;
        block6: {
            int n;
            block5: {
                int sizeArrayFeatures;
                int numFeatures;
                block4: {
                    int n2;
                    int n3;
                    option = BaggingMetadataUtils$.MODULE$.getNumFeatures(dataset.schema().apply(featuresCol));
                    if (!(option instanceof Some)) break block4;
                    Some some = (Some)option;
                    n = n3 = (n2 = BoxesRunTime.unboxToInt((Object)some.x()));
                    break block5;
                }
                if (!None$.MODULE$.equals(option)) break block6;
                Row[] sizeFeaturesCol = (Row[])dataset.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.size(functions$.MODULE$.col(featuresCol))})).take(1);
                if (Predef$.MODULE$.refArrayOps((Object[])sizeFeaturesCol).isEmpty() || sizeFeaturesCol[0].get(0) == null) {
                    throw new SparkException("ML algorithm was given empty dataset.");
                }
                n = numFeatures = (sizeArrayFeatures = ((Row)Predef$.MODULE$.refArrayOps((Object[])sizeFeaturesCol).head()).getInt(0));
            }
            return n;
        }
        throw new MatchError(option);
    }

    public static void $init$(BaggingPredictor $this) {
        $this.org$apache$spark$ml$bagging$BaggingPredictor$_setter_$toArr_$eq((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final double[] apply(Object x$1) {
                return ((DenseVector)x$1).toArray();
            }
        });
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(BaggingPredictor.class.getClassLoader());
        public final class Org_apache_spark_ml_bagging_BaggingPredictor$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{$m.staticClass("scala.Double").asType().toTypeConstructor()})));
            }

            public Org_apache_spark_ml_bagging_BaggingPredictor$$typecreator1$1(BaggingPredictor $outer) {
            }
        }
        $this.org$apache$spark$ml$bagging$BaggingPredictor$_setter_$toArrUdf_$eq(functions$.MODULE$.udf($this.toArr(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_bagging_BaggingPredictor$$typecreator1$1($this)), ((TypeTags)package$.MODULE$.universe()).TypeTag().Any()));
        $this.org$apache$spark$ml$bagging$BaggingPredictor$_setter_$toVector_$eq((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Vector apply(Seq<Object> seq) {
                return Vectors$.MODULE$.dense((double[])seq.toArray(ClassTag$.MODULE$.Double()));
            }
        });
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(BaggingPredictor.class.getClassLoader());
        JavaUniverse $u3 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m3 = package$.MODULE$.universe().runtimeMirror(BaggingPredictor.class.getClassLoader());
        public final class Org_apache_spark_ml_bagging_BaggingPredictor$$typecreator2$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
            }

            public Org_apache_spark_ml_bagging_BaggingPredictor$$typecreator2$1(BaggingPredictor $outer) {
            }
        }
        public final class Org_apache_spark_ml_bagging_BaggingPredictor$$typecreator3$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().thisPrefix((Symbols.SymbolApi)$m.RootClass()), (Symbols.SymbolApi)$m.staticPackage("scala")), (Symbols.SymbolApi)$m.staticModule("scala.package")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.package").asModule().moduleClass(), "Seq"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{$m.staticClass("scala.Double").asType().toTypeConstructor()})));
            }

            public Org_apache_spark_ml_bagging_BaggingPredictor$$typecreator3$1(BaggingPredictor $outer) {
            }
        }
        $this.org$apache$spark$ml$bagging$BaggingPredictor$_setter_$toVectorUdf_$eq(functions$.MODULE$.udf($this.toVector(), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_bagging_BaggingPredictor$$typecreator2$1($this)), ((TypeTags)$u3).TypeTag().apply((Mirror)$m3, (TypeCreator)new Org_apache_spark_ml_bagging_BaggingPredictor$$typecreator3$1($this))));
    }
}

