/*
 * Decompiled with CFR 0.152.
 */
package com.github.oceanc.mybatis3.generator.plugin;

import com.github.oceanc.mybatis3.generator.plugin.PluginUtils;
import java.util.List;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.PluginAdapter;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.InnerClass;
import org.mybatis.generator.api.dom.java.JavaElement;
import org.mybatis.generator.api.dom.java.JavaVisibility;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.Parameter;
import org.mybatis.generator.api.dom.java.TopLevelClass;

public class WhereSqlTextPlugin
extends PluginAdapter {
    private static final String WHERE_SQL = "whereSql";

    public boolean validate(List<String> warnings) {
        return true;
    }

    public boolean modelExampleClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        String sqlexp = introspectedTable.getTableConfigurationProperty(WHERE_SQL);
        if ("true".equals(sqlexp)) {
            for (InnerClass innerClass : topLevelClass.getInnerClasses()) {
                if (!FullyQualifiedJavaType.getGeneratedCriteriaInstance().equals((Object)innerClass.getType())) continue;
                String tableName = introspectedTable.getFullyQualifiedTableNameAtRuntime();
                Method method = new Method();
                method.setName("addConditionSql");
                method.setVisibility(JavaVisibility.PUBLIC);
                method.setReturnType(FullyQualifiedJavaType.getCriteriaInstance());
                method.addBodyLine("addCriterion(conditionSql);");
                method.addBodyLine("return (Criteria) this;");
                method.addParameter(new Parameter(FullyQualifiedJavaType.getStringInstance(), "conditionSql"));
                PluginUtils.addDoc(this.getContext(), (JavaElement)method, tableName);
                innerClass.getMethods().add(method);
                System.out.println("-----------------" + topLevelClass.getType().getShortName() + " add method=addConditionSql for custom sql statement in where clause.");
            }
        }
        return true;
    }
}

