/*
 * Decompiled with CFR 0.152.
 */
package com.github.oceanc.mybatis3.generator.plugin;

import com.github.oceanc.mybatis3.generator.plugin.PluginUtils;
import java.text.MessageFormat;
import java.util.List;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.PluginAdapter;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.Interface;
import org.mybatis.generator.api.dom.java.JavaElement;
import org.mybatis.generator.api.dom.java.JavaVisibility;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.Parameter;
import org.mybatis.generator.api.dom.java.TopLevelClass;
import org.mybatis.generator.api.dom.xml.Document;
import org.mybatis.generator.api.dom.xml.TextElement;

public class SumSelectivePlugin
extends PluginAdapter {
    private static final String SUM_COL_FIELD = "sumCol";
    private static final FullyQualifiedJavaType LONG_TYPE = new FullyQualifiedJavaType("java.lang.Long");
    private static final String template = "<select id=\"sumByExample\" parameterType=\"{0}\" resultType=\"long\" >\n    select sum('${'sumCol'}') from {1}\n    <if test=\"_parameter != null\" >\n      <include refid=\"Example_Where_Clause\" />\n    </if>\n  </select>";

    public boolean validate(List<String> warnings) {
        return true;
    }

    public boolean clientGenerated(Interface interfaze, TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        FullyQualifiedJavaType paramType = new FullyQualifiedJavaType(introspectedTable.getExampleType());
        Method method = new Method();
        method.setName("sumByExample");
        method.setVisibility(JavaVisibility.PUBLIC);
        method.addParameter(new Parameter(paramType, "example"));
        method.setReturnType(LONG_TYPE);
        interfaze.addMethod(method);
        System.out.println("-----------------" + interfaze.getType().getShortName() + " add method sumByExample.");
        return true;
    }

    public boolean modelExampleClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        String tableName = introspectedTable.getFullyQualifiedTableNameAtRuntime();
        PluginUtils.addProperty(SUM_COL_FIELD, topLevelClass, this.getContext(), tableName);
        List columns = introspectedTable.getAllColumns();
        for (IntrospectedColumn column : columns) {
            String field = column.getJavaProperty();
            String mn = "sum" + field.substring(0, 1).toUpperCase() + field.substring(1, field.length());
            Method method = new Method();
            method.setName(mn);
            method.setVisibility(JavaVisibility.PUBLIC);
            method.setReturnType(topLevelClass.getType());
            method.addBodyLine("this.sumCol=\"" + column.getActualColumnName() + "\";");
            method.addBodyLine("return this;");
            PluginUtils.addDoc(this.getContext(), (JavaElement)method, tableName);
            topLevelClass.addMethod(method);
        }
        return true;
    }

    public boolean sqlMapDocumentGenerated(Document document, IntrospectedTable introspectedTable) {
        String paramType = introspectedTable.getExampleType();
        String tableName = introspectedTable.getFullyQualifiedTableNameAtRuntime();
        String xml = MessageFormat.format(template, paramType, tableName);
        document.getRootElement().getElements().add(new TextElement(xml));
        return true;
    }
}

