/*
 * Decompiled with CFR 0.152.
 */
package com.github.oceanc.mybatis3.generator.plugin;

import com.github.oceanc.mybatis3.generator.plugin.PluginUtils;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.Plugin;
import org.mybatis.generator.api.PluginAdapter;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.InnerClass;
import org.mybatis.generator.api.dom.java.Interface;
import org.mybatis.generator.api.dom.java.JavaElement;
import org.mybatis.generator.api.dom.java.JavaVisibility;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.Parameter;
import org.mybatis.generator.api.dom.java.TopLevelClass;
import org.mybatis.generator.api.dom.xml.Attribute;
import org.mybatis.generator.api.dom.xml.TextElement;
import org.mybatis.generator.api.dom.xml.XmlElement;
import org.mybatis.generator.config.TableConfiguration;

public class SliceTablePlugin
extends PluginAdapter {
    private static final String REL_COLUMN = "sliceColumn";
    private static final String MOD_VALUE = "sliceMod";
    private static final String TIME_VALUE = "sliceMonth";
    private static final String SUFFIX_FIELD = "tableNameSuffix";
    private static final FullyQualifiedJavaType STRING_TYPE = new FullyQualifiedJavaType("java.lang.String");
    private static final FullyQualifiedJavaType DATE_TYPE = new FullyQualifiedJavaType("java.util.Date");
    private static final FullyQualifiedJavaType CALENDAR_TYPE = new FullyQualifiedJavaType("java.util.Calendar");
    private static final FullyQualifiedJavaType BIGDECIMAL_TYPE = new FullyQualifiedJavaType("java.math.BigDecimal");
    private static final String UNDERLINE = "_";
    private static final String PARTITION_FACTOR = "partitionFactor";
    private static final String SUFFIX = "_${tableNameSuffix}";
    private static final String SQL_MAP_PARAMETER_TYPE = "parameterType";

    public boolean validate(List<String> warnings) {
        return true;
    }

    public void initialized(IntrospectedTable introspectedTable) {
        if (SliceTablePlugin.needPartition(introspectedTable)) {
            String tableName = introspectedTable.getFullyQualifiedTableNameAtRuntime();
            String modValue = introspectedTable.getTableConfigurationProperty(MOD_VALUE);
            String month = introspectedTable.getTableConfigurationProperty(TIME_VALUE);
            if (modValue != null && !"".equals(modValue) || month != null && !"".equals(month)) {
                String baseName = tableName.substring(0, tableName.lastIndexOf(UNDERLINE));
                introspectedTable.setSqlMapAliasedFullyQualifiedRuntimeTableName(baseName + SUFFIX);
                introspectedTable.setSqlMapFullyQualifiedRuntimeTableName(baseName + SUFFIX);
            }
        }
    }

    public boolean modelExampleClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        if (SliceTablePlugin.needPartition(introspectedTable)) {
            String tableName = introspectedTable.getFullyQualifiedTableNameAtRuntime();
            String relColumn = introspectedTable.getTableConfigurationProperty(REL_COLUMN);
            String modValue = introspectedTable.getTableConfigurationProperty(MOD_VALUE);
            String month = introspectedTable.getTableConfigurationProperty(TIME_VALUE);
            String fieldName = this.convertColumnName(relColumn, introspectedTable.getTableConfiguration());
            if (modValue != null && !"".equals(modValue)) {
                FullyQualifiedJavaType ptype = STRING_TYPE;
                for (InnerClass innerClass : topLevelClass.getInnerClasses()) {
                    if (!FullyQualifiedJavaType.getGeneratedCriteriaInstance().equals((Object)innerClass.getType())) continue;
                    for (Method method : innerClass.getMethods()) {
                        String FN = fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1, fieldName.length());
                        if (!method.getName().equals("and" + FN + "EqualTo")) continue;
                        Parameter parm = (Parameter)method.getParameters().get(0);
                        ptype = parm.getType();
                    }
                }
                String[] expression = new String[]{"if (" + fieldName + " != null ) {", "long nan = 0;", "StringBuilder sb = new StringBuilder(\"0\");", "for (char c : String.valueOf(" + fieldName + ").toCharArray()) {", "if (Character.isDigit(c)) sb.append(c);", "else nan += c;", "}", "long lid = new BigDecimal(sb.toString()).longValue();", "if(nan > 0) lid += " + modValue + " + nan;", "this.tableNameSuffix = (Math.abs(lid) % " + modValue + ") + \"\";", "}", "return this;"};
                Method method = this.makePartitionMethod(ptype, topLevelClass.getType(), fieldName, tableName, expression);
                topLevelClass.addImportedType(BIGDECIMAL_TYPE);
                topLevelClass.addMethod(method);
                System.out.println("-----------------" + topLevelClass.getType().getShortName() + " add method " + method.getName() + ".");
            } else if (month != null && !"".equals(month)) {
                String[] expression = new String[]{"if (" + fieldName + " != null ) {", "Calendar calendar = Calendar.getInstance();", "calendar.setTimeInMillis(" + fieldName + ".getTime());", "int m = calendar.get(Calendar.MONTH) + 1;", "this.tableNameSuffix = calendar.get(Calendar.YEAR) + (m < 10 ? \"0\" + m : \"\" + m);", "}", "return this;"};
                Method method = this.makePartitionMethod(DATE_TYPE, topLevelClass.getType(), fieldName, tableName, expression);
                topLevelClass.addImportedType(CALENDAR_TYPE);
                topLevelClass.addMethod(method);
                System.out.println("-----------------" + topLevelClass.getType().getShortName() + " add method " + method.getName() + ".");
            }
            PluginUtils.addProperty(SUFFIX_FIELD, topLevelClass, this.getContext(), tableName);
        }
        return true;
    }

    public boolean modelBaseRecordClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        if (SliceTablePlugin.needPartition(introspectedTable)) {
            String tableName = introspectedTable.getFullyQualifiedTableNameAtRuntime();
            PluginUtils.addProperty(SUFFIX_FIELD, topLevelClass, this.getContext(), tableName);
        }
        return true;
    }

    public boolean modelRecordWithBLOBsClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        if (SliceTablePlugin.needPartition(introspectedTable)) {
            String tableName = introspectedTable.getFullyQualifiedTableNameAtRuntime();
            PluginUtils.addProperty(SUFFIX_FIELD, topLevelClass, this.getContext(), tableName);
        }
        return true;
    }

    public boolean modelSetterMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedColumn introspectedColumn, IntrospectedTable introspectedTable, Plugin.ModelClassType modelClassType) {
        if (SliceTablePlugin.needPartition(introspectedTable)) {
            String relColumn = introspectedTable.getTableConfigurationProperty(REL_COLUMN);
            if (introspectedColumn.getActualColumnName().equals(relColumn)) {
                String modValue = introspectedTable.getTableConfigurationProperty(MOD_VALUE);
                String month = introspectedTable.getTableConfigurationProperty(TIME_VALUE);
                String field = introspectedColumn.getJavaProperty();
                if (modValue != null && !"".equals(modValue)) {
                    if (!SliceTablePlugin.isPrime(Long.parseLong(modValue))) {
                        System.err.printf("modValue should be a prime number!!!!!!", new Object[0]);
                    }
                    String[] expression = new String[]{"if (this." + field + " != null ) {", "long nan = 0;", "StringBuilder sb = new StringBuilder(\"0\");", "for (char c : String.valueOf(" + field + ").toCharArray()) {", "if (Character.isDigit(c)) sb.append(c);", "else nan += c;", "}", "long lid = new BigDecimal(sb.toString()).longValue();", "if(nan > 0) lid += " + modValue + " + nan;", "this.tableNameSuffix = (Math.abs(lid) % " + modValue + ") + \"\";", "}"};
                    method.addBodyLines(Arrays.asList(expression));
                    topLevelClass.addImportedType(BIGDECIMAL_TYPE);
                    System.out.println("-----------------" + topLevelClass.getType().getShortName() + " modify method " + method.getName() + " for update field " + SUFFIX_FIELD);
                } else if (month != null && !"".equals(month)) {
                    int mc = Integer.parseInt(month);
                    if (mc < 1 || mc > 12) {
                        System.err.printf("month value should in [1-12]!!!!!!", new Object[0]);
                        throw new IllegalArgumentException("month value should in [1-12]!!!!!!");
                    }
                    String[] expression = new String[]{"if (this." + field + " != null ) {", "Calendar calendar = Calendar.getInstance();", "calendar.setTimeInMillis(" + field + ".getTime());", "int m = calendar.get(Calendar.MONTH) + 1;", "this.tableNameSuffix = calendar.get(Calendar.YEAR) + (m < 10 ? \"0\" + m : \"\" + m);", "}"};
                    method.addBodyLines(Arrays.asList(expression));
                    topLevelClass.addImportedType(CALENDAR_TYPE);
                    System.out.println("-----------------" + topLevelClass.getType().getShortName() + " modify method " + method.getName() + " for update field " + SUFFIX_FIELD);
                }
            }
        }
        return true;
    }

    public boolean sqlMapUpdateByExampleWithoutBLOBsElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        return this.dynamicTableName(element, introspectedTable);
    }

    public boolean sqlMapUpdateByExampleSelectiveElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        return this.dynamicTableName(element, introspectedTable);
    }

    public boolean sqlMapSelectByPrimaryKeyElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        System.out.println("-----------------" + introspectedTable.getAliasedFullyQualifiedTableNameAtRuntime() + " replace parameter type to " + introspectedTable.getBaseRecordType() + " of SelectByPrimaryKey in sql xml");
        return this.replaceParamType(element, introspectedTable);
    }

    public boolean sqlMapDeleteByPrimaryKeyElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        System.out.println("-----------------" + introspectedTable.getAliasedFullyQualifiedTableNameAtRuntime() + " replace parameter type to " + introspectedTable.getBaseRecordType() + " of DeleteByPrimaryKey in sql xml");
        return this.replaceParamType(element, introspectedTable);
    }

    public boolean clientSelectByPrimaryKeyMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        System.out.println("-----------------" + interfaze.getType().getShortName() + " replace parameter type to " + introspectedTable.getBaseRecordType() + " of SelectByPrimaryKey in client class' method " + method.getName());
        return this.replaceParamType(method, introspectedTable);
    }

    public boolean clientDeleteByPrimaryKeyMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        System.out.println("-----------------" + interfaze.getType().getShortName() + " replace parameter type to " + introspectedTable.getBaseRecordType() + " of DeleteByPrimaryKey in client class' method " + method.getName());
        return this.replaceParamType(method, introspectedTable);
    }

    private Method makePartitionMethod(FullyQualifiedJavaType paramType, FullyQualifiedJavaType returnType, String fieldName, String tableName, String[] exp) {
        String methodName = PARTITION_FACTOR + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1, fieldName.length());
        Method method = new Method();
        method.setName(methodName);
        method.setVisibility(JavaVisibility.PUBLIC);
        method.setReturnType(returnType);
        method.addBodyLines(Arrays.asList(exp));
        method.addParameter(new Parameter(paramType, fieldName));
        PluginUtils.addDoc(this.getContext(), (JavaElement)method, tableName);
        return method;
    }

    protected static boolean needPartition(IntrospectedTable introspectedTable) {
        String relColumn = introspectedTable.getTableConfigurationProperty(REL_COLUMN);
        return relColumn != null && !"".equals(relColumn);
    }

    private String convertColumnName(String column, TableConfiguration configuration) {
        String name = SliceTablePlugin.camelcase(column.split(UNDERLINE));
        if (configuration.getColumnOverride(column) != null) {
            name = configuration.getColumnOverride(column).getJavaProperty();
        } else if (configuration.getColumnRenamingRule() != null) {
            String search = configuration.getColumnRenamingRule().getSearchString();
            String replace = configuration.getColumnRenamingRule().getReplaceString();
            name = column.replaceAll(search, replace);
        }
        return name;
    }

    private static String camelcase(String[] words) {
        StringBuilder sb = new StringBuilder(words[0].toLowerCase());
        for (int i = 1; i < words.length; ++i) {
            sb.append(words[i].substring(0, 1).toUpperCase());
            if (words[i].length() <= 1) continue;
            sb.append(words[i].substring(1, words[i].length()).toLowerCase());
        }
        return sb.toString();
    }

    private boolean replaceParamType(Method method, IntrospectedTable introspectedTable) {
        if (SliceTablePlugin.needPartition(introspectedTable)) {
            for (Parameter parameter : method.getParameters()) {
                try {
                    String classType = introspectedTable.getBaseRecordType();
                    Field field = parameter.getClass().getDeclaredField("name");
                    field.setAccessible(true);
                    field.set(parameter, "record");
                    field = parameter.getClass().getDeclaredField("type");
                    field.setAccessible(true);
                    field.set(parameter, new FullyQualifiedJavaType(classType));
                }
                catch (NoSuchFieldException e) {
                    System.err.println("replace parameter type error" + e);
                }
                catch (IllegalAccessException e) {
                    System.err.println("replace parameter type error" + e);
                }
            }
        }
        return true;
    }

    private boolean replaceParamType(XmlElement element, IntrospectedTable introspectedTable) {
        if (SliceTablePlugin.needPartition(introspectedTable)) {
            for (Attribute attribute : element.getAttributes()) {
                if (!SQL_MAP_PARAMETER_TYPE.equals(attribute.getName())) continue;
                try {
                    String classType = introspectedTable.getBaseRecordType();
                    Field field = attribute.getClass().getDeclaredField("value");
                    field.setAccessible(true);
                    field.set(attribute, classType);
                }
                catch (NoSuchFieldException e) {
                    System.err.println("replace parameter type error" + e);
                }
                catch (IllegalAccessException e) {
                    System.err.println("replace parameter type error" + e);
                }
            }
        }
        return true;
    }

    private boolean dynamicTableName(XmlElement element, IntrospectedTable introspectedTable) {
        if (SliceTablePlugin.needPartition(introspectedTable)) {
            TextElement sqlhead = (TextElement)element.getElements().get(0);
            try {
                String dynamicTableName = introspectedTable.getAliasedFullyQualifiedTableNameAtRuntime();
                String baseName = dynamicTableName.substring(0, dynamicTableName.lastIndexOf(UNDERLINE));
                String sfx = "<choose>";
                sfx = sfx + "<when test=\"record.tableNameSuffix != null\">" + baseName + "_${record." + SUFFIX_FIELD + "}</when>";
                sfx = sfx + "<when test=\"example.tableNameSuffix != null\">" + baseName + "_${example." + SUFFIX_FIELD + "}</when>";
                sfx = sfx + "<otherwise>" + baseName + "_ </otherwise>";
                sfx = sfx + "</choose>";
                Field field = sqlhead.getClass().getDeclaredField("content");
                field.setAccessible(true);
                field.set(sqlhead, "update " + sfx);
                System.out.println("-----------------" + baseName + "generate dynamic table name base on {} in sql xml");
            }
            catch (NoSuchFieldException e) {
                System.err.println("generate dynamic table name error" + e);
            }
            catch (IllegalAccessException e) {
                System.err.println("generate dynamic table name error" + e);
            }
        }
        return true;
    }

    private static boolean isPrime(long N) {
        if (N < 2L) {
            return false;
        }
        int i = 2;
        while ((long)(i * i) <= N) {
            if (N % (long)i == 0L) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

