/*
 * Decompiled with CFR 0.152.
 */
package com.github.oceanc.mybatis3.generator.plugin;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.mybatis.generator.api.dom.java.Field;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.JavaElement;
import org.mybatis.generator.api.dom.java.JavaVisibility;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.Parameter;
import org.mybatis.generator.api.dom.java.TopLevelClass;
import org.mybatis.generator.config.Context;

public abstract class PluginUtils {
    private static SimpleDateFormat df = new SimpleDateFormat("EEE MMM ww HH:mm:ss z yyyy", Locale.US);

    public static void addProperty(String field, TopLevelClass topLevelClass, Context context, String tableName) {
        for (Method method : topLevelClass.getMethods()) {
            if (!method.getName().equals("clear")) continue;
            method.addBodyLine("this." + field + " = null;");
        }
        topLevelClass.addField(PluginUtils.makeStringField(context, field, tableName));
        topLevelClass.addMethod(PluginUtils.makeGetterStringMethod(context, field, tableName));
        topLevelClass.addMethod(PluginUtils.makeSetterStringMethod(context, field, tableName));
        System.out.println("-----------------" + topLevelClass.getType().getShortName() + " add field " + field + " and getter related.");
    }

    public static Field makeStringField(Context context, String fieldName, String tableName) {
        Field field = new Field();
        field.setName(fieldName);
        field.setVisibility(JavaVisibility.PRIVATE);
        field.setType(FullyQualifiedJavaType.getStringInstance());
        PluginUtils.addDoc(context, (JavaElement)field, tableName);
        return field;
    }

    public static Method makeGetterStringMethod(Context context, String fieldName, String tableName) {
        String methodName = "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1, fieldName.length());
        Method method = new Method();
        method.setName(methodName);
        method.setVisibility(JavaVisibility.PUBLIC);
        method.setReturnType(FullyQualifiedJavaType.getStringInstance());
        method.addBodyLine("return this." + fieldName + ";");
        PluginUtils.addDoc(context, (JavaElement)method, tableName);
        return method;
    }

    public static Method makeSetterStringMethod(Context context, String fieldName, String tableName) {
        String methodName = "set" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1, fieldName.length());
        Method method = new Method();
        method.setName(methodName);
        method.setVisibility(JavaVisibility.PUBLIC);
        method.addParameter(new Parameter(FullyQualifiedJavaType.getStringInstance(), fieldName));
        method.addBodyLine("this." + fieldName + " = " + fieldName + ";");
        PluginUtils.addDoc(context, (JavaElement)method, tableName);
        return method;
    }

    public static void addDoc(Context context, JavaElement element, String tableName) {
        String suppressAllComments = context.getCommentGeneratorConfiguration().getProperty("suppressAllComments");
        if (!"true".equals(suppressAllComments)) {
            String type = element.getClass() == Field.class ? "field" : "method";
            element.addJavaDocLine("/**");
            element.addJavaDocLine("* This " + type + " was generated by MyBatis Generator.");
            element.addJavaDocLine("* This " + type + " corresponds to the database table " + tableName);
            element.addJavaDocLine("*");
            element.addJavaDocLine("* @mbggenerated " + df.format(new Date()));
            element.addJavaDocLine("*/");
        }
    }
}

