/*
 * Decompiled with CFR 0.152.
 */
package com.github.oceanc.mybatis3.generator.plugin;

import java.util.List;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.Plugin;
import org.mybatis.generator.api.PluginAdapter;
import org.mybatis.generator.api.dom.java.Field;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.TopLevelClass;

public class JacksonAnnotationPlugin
extends PluginAdapter {
    private static final String DELIMITER = ",";
    private static final String DELIMITER_FORMAT = "@";
    private static final String JACKSON_COLUMNS = "jacksonColumns";
    private static final String JACKSON_PROPERTIES = "jacksonProperties";
    private static final String JACKSON_FORMATS = "jacksonFormats";
    private static final String JACKSON_IGNORES = "jacksonIgnores";

    public boolean validate(List<String> warnings) {
        return true;
    }

    public boolean modelFieldGenerated(Field field, TopLevelClass topLevelClass, IntrospectedColumn introspectedColumn, IntrospectedTable introspectedTable, Plugin.ModelClassType modelClassType) {
        String format;
        String prop = this.annotateProperty(introspectedColumn, introspectedTable);
        if (prop != null) {
            String ann = "@JsonProperty(\"" + prop + "\")";
            field.addAnnotation(ann);
            topLevelClass.addImportedType(new FullyQualifiedJavaType("com.fasterxml.jackson.annotation.JsonProperty"));
            System.out.println("-----------------" + topLevelClass.getType().getShortName() + " add field annotation " + ann + " to " + field.getName() + " implement by Jackson2.");
        }
        if ((format = this.annotateFormat(introspectedColumn, introspectedTable)) != null) {
            String ann = "@JsonFormat(pattern = \"" + format + "\")";
            field.addAnnotation(ann);
            topLevelClass.addImportedType(new FullyQualifiedJavaType("com.fasterxml.jackson.annotation.JsonFormat"));
            System.out.println("-----------------" + topLevelClass.getType().getShortName() + " add field annotation " + ann + " to " + field.getName() + " implement by Jackson2.");
        }
        this.annotateIgnore(field, topLevelClass, introspectedColumn, introspectedTable);
        return true;
    }

    private String annotateProperty(IntrospectedColumn introspectedColumn, IntrospectedTable introspectedTable) {
        String cls = introspectedTable.getTableConfigurationProperty(JACKSON_COLUMNS);
        if (cls != null && !"".equals(cls)) {
            String[] columns = cls.split(DELIMITER);
            for (int i = 0; i < columns.length; ++i) {
                if (!columns[i].trim().equals(introspectedColumn.getActualColumnName())) continue;
                String pps = introspectedTable.getTableConfigurationProperty(JACKSON_PROPERTIES);
                return pps.split(DELIMITER)[i].trim();
            }
        }
        return null;
    }

    private String annotateFormat(IntrospectedColumn introspectedColumn, IntrospectedTable introspectedTable) {
        String fmts = introspectedTable.getTableConfigurationProperty(JACKSON_FORMATS);
        if (fmts != null && !"".equals(fmts)) {
            String[] columns;
            String[] formats = fmts.split(DELIMITER_FORMAT);
            String anno = formats[1];
            for (String column : columns = formats[0].split(DELIMITER)) {
                if (!column.equals(introspectedColumn.getActualColumnName())) continue;
                return anno;
            }
        }
        return null;
    }

    private void annotateIgnore(Field field, TopLevelClass topLevelClass, IntrospectedColumn introspectedColumn, IntrospectedTable introspectedTable) {
        String cls = introspectedTable.getTableConfigurationProperty(JACKSON_IGNORES);
        if (cls != null && !"".equals(cls)) {
            String[] columns;
            for (String column : columns = cls.split(DELIMITER)) {
                if (!column.trim().equals(introspectedColumn.getActualColumnName())) continue;
                field.addAnnotation("@JsonIgnore");
                topLevelClass.addImportedType(new FullyQualifiedJavaType("com.fasterxml.jackson.annotation.JsonIgnore"));
                System.out.println("-----------------" + topLevelClass.getType().getShortName() + " add field annotation @JsonIgnore to " + field.getName() + " implement by Jackson2.");
            }
        }
    }
}

