/*
 * Decompiled with CFR 0.152.
 */
package com.github.oceanc.mybatis3.generator.plugin;

import com.github.oceanc.mybatis3.generator.plugin.SliceTablePlugin;
import java.text.MessageFormat;
import java.util.List;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.PluginAdapter;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.Interface;
import org.mybatis.generator.api.dom.java.JavaVisibility;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.Parameter;
import org.mybatis.generator.api.dom.java.TopLevelClass;
import org.mybatis.generator.api.dom.xml.Attribute;
import org.mybatis.generator.api.dom.xml.Document;
import org.mybatis.generator.api.dom.xml.Element;
import org.mybatis.generator.api.dom.xml.TextElement;
import org.mybatis.generator.api.dom.xml.XmlElement;

public class BatchInsertPlugin
extends PluginAdapter {
    private static final FullyQualifiedJavaType PARAM_ANOTS = new FullyQualifiedJavaType("org.apache.ibatis.annotations.Param");
    private static final String methodName = "batchInsert";
    private static final String template = "<insert id=\"batchInsert\">\n{0}    insert into {1} {2}\n    values\n    <foreach collection=\"items\" item=\"item\" index=\"index\" separator=\",\">\n{3}    </foreach>\n  </insert>";

    public boolean validate(List<String> warnings) {
        return true;
    }

    public boolean clientGenerated(Interface interfaze, TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        FullyQualifiedJavaType paramType = FullyQualifiedJavaType.getNewListInstance();
        paramType.addTypeArgument(new FullyQualifiedJavaType(introspectedTable.getBaseRecordType()));
        Method method = new Method();
        method.setName(methodName);
        method.setVisibility(JavaVisibility.PUBLIC);
        method.addParameter(new Parameter(paramType, "items", "@Param(\"items\")"));
        interfaze.addMethod(method);
        interfaze.addImportedType(PARAM_ANOTS);
        System.out.println("-----------------" + interfaze.getType().getShortName() + " add method " + methodName + ".");
        return true;
    }

    public boolean sqlMapDocumentGenerated(Document document, IntrospectedTable introspectedTable) {
        XmlElement node = this.findInsertNode(document);
        if (node != null) {
            String tableName;
            StringBuilder values = new StringBuilder();
            for (Element el : node.getElements()) {
                if (el.getClass() != TextElement.class) continue;
                TextElement tl = (TextElement)el;
                values.append("      ").append(tl.getContent()).append("\n");
            }
            String[] insertStr = values.toString().split("values \\(");
            String fs = insertStr[0];
            fs = " (" + fs.split(" \\(")[1].trim();
            String xx = "      (" + insertStr[1];
            xx = xx.replaceAll("#\\{", "#\\{item.");
            String bind = "";
            if (SliceTablePlugin.needPartition(introspectedTable)) {
                bind = "    <bind name=\"tableNameSuffix\" value=\"items.get(0).getTableNameSuffix()\" />\n";
            }
            if (!(tableName = introspectedTable.getFullyQualifiedTableNameAtRuntime()).contains("_${tableNameSuffix}") && SliceTablePlugin.needPartition(introspectedTable)) {
                tableName = tableName + "_${tableNameSuffix}";
            }
            String xml = MessageFormat.format(template, bind, tableName, fs, xx);
            document.getRootElement().getElements().add(new TextElement(xml));
            return true;
        }
        return false;
    }

    private XmlElement findInsertNode(Document document) {
        for (Element el : document.getRootElement().getElements()) {
            XmlElement xl;
            if (el.getClass() != XmlElement.class || !(xl = (XmlElement)el).getName().equals("insert")) continue;
            for (Attribute attr : xl.getAttributes()) {
                if (!attr.getName().equals("id") || !attr.getValue().equals("insert")) continue;
                return xl;
            }
        }
        return null;
    }
}

