/*
 * Decompiled with CFR 0.152.
 */
package com.nyvi.core.common.util;

import com.nyvi.core.common.util.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.springframework.cglib.beans.BeanMap;

public class BeanMapUtils {
    private BeanMapUtils() {
    }

    public static final <T> Map<String, Object> beanToMap(T bean) {
        return BeanMapUtils.beanToMap(bean, true);
    }

    public static final <T> Map<String, Object> beanToMap(T bean, boolean ignore) {
        if (Objects.isNull(bean)) {
            return new HashMap<String, Object>(0);
        }
        BeanMap beanMap = BeanMap.create(bean);
        HashMap<String, Object> map = new HashMap<String, Object>(Maps.capacity(beanMap.size()));
        for (Object key : beanMap.keySet()) {
            Object value = beanMap.get(key);
            if (ignore && Objects.isNull(value)) continue;
            map.put(key.toString(), value);
        }
        return map;
    }

    public static <T> T mapToBean(Map<String, Object> map, T bean) {
        BeanMap beanMap = BeanMap.create(bean);
        beanMap.putAll(map);
        return bean;
    }
}

