/*
 * Decompiled with CFR 0.152.
 */
package com.nyvi.core.base.service.impl;

import com.nyvi.core.base.dao.BaseDAO;
import com.nyvi.core.base.dto.TableData;
import com.nyvi.core.base.mode.BaseDO;
import com.nyvi.core.base.query.BaseQuery;
import com.nyvi.core.base.service.BaseService;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class BaseServiceImpl<T extends BaseDO>
implements BaseService<T> {
    @Autowired
    private BaseDAO<T> baseDAO;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int save(T t) throws Exception {
        return this.baseDAO.save(t);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int update(T t) throws Exception {
        return this.baseDAO.update(t);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int saveOrUpdate(T t) throws Exception {
        if (Objects.isNull(((BaseDO)t).getId())) {
            return this.baseDAO.save(t);
        }
        return this.baseDAO.update(t);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int batchSave(List<T> list) throws Exception {
        return this.baseDAO.batchSave(list);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int delete(Long id) throws Exception {
        return this.baseDAO.delete(id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int batchDelete(List<Long> idList) throws Exception {
        return this.baseDAO.batchDelete(idList);
    }

    @Override
    public <Q extends BaseQuery> int getCount(Q query) {
        return this.baseDAO.getCount(query);
    }

    @Override
    public T getEntity(Long id) {
        return this.baseDAO.getEntity(id);
    }

    @Override
    public <Q extends BaseQuery> List<T> getList(Q query) {
        return this.baseDAO.getList(query);
    }

    @Override
    public <Q extends BaseQuery> TableData<T> getTableData(Q query) {
        int count = this.getCount(query);
        if (count > 0) {
            List<T> list = this.getList(query);
            return TableData.bulid(count, list);
        }
        return TableData.empty();
    }
}

