/*
 * Decompiled with CFR 0.152.
 */
package com.nyvi.core.base.dao;

import com.nyvi.core.annotation.Column;
import com.nyvi.core.annotation.Query;
import com.nyvi.core.annotation.Table;
import com.nyvi.core.base.mode.BaseDO;
import com.nyvi.core.base.query.BaseQuery;
import com.nyvi.core.common.generator.IdWorkerManage;
import com.nyvi.core.common.util.ArrayUtils;
import com.nyvi.core.common.util.BeanMapUtils;
import com.nyvi.core.common.util.Maps;
import com.nyvi.core.common.util.StrUtils;
import com.nyvi.core.enums.Operate;
import com.nyvi.core.exception.ColumnNotFoundException;
import com.nyvi.core.exception.TableNotFoundException;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSourceUtils;
import org.springframework.util.CollectionUtils;

public class BaseDAO<T extends BaseDO> {
    @Autowired
    protected NamedParameterJdbcTemplate namedParameterJdbcTemplate;
    private Class<T> cls;

    public BaseDAO() {
        ParameterizedType type = (ParameterizedType)this.getClass().getGenericSuperclass();
        this.cls = (Class)type.getActualTypeArguments()[0];
    }

    public int save(T t) {
        if (Objects.isNull(((BaseDO)t).getId())) {
            ((BaseDO)t).setId(IdWorkerManage.getId());
        }
        ((BaseDO)t).setGmtCreate(new Date());
        ((BaseDO)t).setGmtModified(((BaseDO)t).getGmtCreate());
        String sql = this.getInsertSql();
        Map<String, Object> valueMap = BeanMapUtils.beanToMap(t);
        return this.namedParameterJdbcTemplate.update(sql, valueMap);
    }

    public int delete(Long id) {
        String sql = this.getDeleteSql();
        Map<String, Long> paramMap = Collections.singletonMap(this.getPrimaryKey(), id);
        return this.namedParameterJdbcTemplate.update(sql, paramMap);
    }

    public int update(T t) {
        ((BaseDO)t).setGmtCreate(null);
        ((BaseDO)t).setGmtModified(new Date());
        HashMap<String, Object> valueMap = Maps.newHashMap(16);
        String sql = this.getUpdateSql(t, valueMap);
        return this.namedParameterJdbcTemplate.update(sql, valueMap);
    }

    public <Q extends BaseQuery> int getCount(Q query) {
        HashMap<String, Object> paramMap = Maps.newHashMap(16);
        String sql = this.getCountSql(query, paramMap);
        return (Integer)this.namedParameterJdbcTemplate.queryForObject(sql, paramMap, Integer.class);
    }

    public T getEntity(long id) {
        String sql = this.getSelectSql();
        BeanPropertyRowMapper rowMapper = BeanPropertyRowMapper.newInstance(this.cls);
        Map<String, Long> paramMap = Collections.singletonMap(this.getPrimaryKey(), id);
        List list = this.namedParameterJdbcTemplate.query(sql, paramMap, (RowMapper)rowMapper);
        return (T)(CollectionUtils.isEmpty((Collection)list) ? null : (BaseDO)list.get(0));
    }

    public <Q extends BaseQuery> List<T> getList(Q query) {
        HashMap<String, Object> paramMap = Maps.newHashMap(16);
        String sql = this.getSelectSql(query, paramMap);
        BeanPropertyRowMapper rowMapper = BeanPropertyRowMapper.newInstance(this.cls);
        return this.namedParameterJdbcTemplate.query(sql, paramMap, (RowMapper)rowMapper);
    }

    public int batchSave(List<T> list) {
        Date date = new Date();
        for (BaseDO t : list) {
            if (Objects.isNull(t.getId())) {
                t.setId(IdWorkerManage.getId());
            }
            t.setGmtCreate(date);
            t.setGmtModified(date);
        }
        String sql = this.getInsertSql();
        SqlParameterSource[] valueParameter = SqlParameterSourceUtils.createBatch((Object[])list.toArray());
        return this.namedParameterJdbcTemplate.batchUpdate(sql, valueParameter).length;
    }

    public int batchDelete(List<Long> idList) {
        String primaryKey = this.getPrimaryKey();
        Map[] valueParameter = new Map[idList.size()];
        int size = idList.size();
        for (int i = 0; i < size; ++i) {
            valueParameter[i] = Collections.singletonMap(primaryKey, idList.get(i));
        }
        String sql = this.getDeleteSql();
        return this.namedParameterJdbcTemplate.batchUpdate(sql, valueParameter).length;
    }

    private String getInsertSql() {
        StringBuffer sql = new StringBuffer(256);
        Map<String, String> fieldMap = this.getFieldMap(true);
        sql.append("insert into ").append(this.getTableName()).append("( ");
        for (String value : fieldMap.values()) {
            sql.append(value).append(",");
        }
        sql.deleteCharAt(sql.length() - 1);
        sql.append(") values (");
        for (String key : fieldMap.keySet()) {
            sql.append(":").append(key).append(",");
        }
        sql.deleteCharAt(sql.length() - 1);
        sql.append(")");
        return sql.toString();
    }

    private String getDeleteSql() {
        StringBuffer sql = new StringBuffer(128);
        String primaryKey = this.getPrimaryKey();
        sql.append("delete from ").append(this.getTableName()).append(" where ").append(primaryKey).append("=:").append(primaryKey);
        return sql.toString();
    }

    private String getUpdateSql(T t, Map<String, Object> valueMap) {
        Map<String, String> fieldMap = this.getFieldMap(false);
        StringBuffer sql = new StringBuffer(256);
        valueMap.putAll(BeanMapUtils.beanToMap(t));
        sql.append("update ").append(this.getTableName()).append(" set ");
        for (String key : valueMap.keySet()) {
            if (!fieldMap.containsKey(key)) continue;
            sql.append(fieldMap.get(key)).append("=:").append(key).append(",");
        }
        sql.deleteCharAt(sql.length() - 1);
        String primaryKey = this.getPrimaryKey();
        sql.append(" where ").append(primaryKey).append("=:").append(primaryKey);
        return sql.toString();
    }

    private <Q extends BaseQuery> String getCountSql(Q query, Map<String, Object> paramMap) {
        StringBuffer sql = new StringBuffer(256);
        sql.append("select count(*) from ").append(this.getTableName()).append(" where 1=1 ");
        this.getWhereSql(sql, query, paramMap);
        return sql.toString();
    }

    private String getSelectSql() {
        String primaryKey = this.getPrimaryKey();
        StringBuffer sql = this.getSelectField();
        sql.append(" where ").append(primaryKey).append("=:").append(primaryKey);
        return sql.toString();
    }

    private <Q extends BaseQuery> String getSelectSql(Q query, Map<String, Object> paramMap) {
        StringBuffer sql = this.getSelectField();
        sql.append(" where 1=1 ");
        this.getWhereSql(sql, query, paramMap);
        if (StrUtils.isNotBlank(query.getOrder())) {
            sql.append(" order by ").append(query.getOrder());
        }
        if (Objects.nonNull(query.getPageSize())) {
            if (Objects.nonNull(query.getPageNumber())) {
                int offset = (query.getPageNumber() - 1) * query.getPageSize();
                if (query.getPageSize() != Integer.MAX_VALUE || offset != 0) {
                    sql.append(" limit ").append(offset).append(",").append(query.getPageSize());
                }
            } else {
                sql.append(" limit ").append(query.getPageSize());
            }
        }
        return sql.toString();
    }

    private <Q extends BaseQuery> void getWhereSql(StringBuffer whereSql, Q query, Map<String, Object> whereMap) {
        Field[] declaredFields = query.getClass().getDeclaredFields();
        if (ArrayUtils.isNotEmpty(declaredFields)) {
            whereMap.putAll(BeanMapUtils.beanToMap(query));
            for (Field field : declaredFields) {
                String s;
                String fieldName = field.getName();
                if (!whereMap.containsKey(fieldName) || !field.isAnnotationPresent(Query.class)) continue;
                Query q = field.getAnnotation(Query.class);
                String value = StrUtils.defaultIfBlank(q.name(), fieldName);
                if (Operate.IN.equals((Object)q.operate())) {
                    if (!"List".equals(field.getType().getSimpleName())) continue;
                    whereSql.append(" and ").append(value).append(" in (:").append(fieldName).append(")");
                    continue;
                }
                if (StrUtils.isNotBlank(q.prefix())) {
                    s = whereMap.get(fieldName).toString();
                    whereMap.put(fieldName, q.prefix() + s);
                }
                if (StrUtils.isNotBlank(q.suffix())) {
                    s = whereMap.get(fieldName).toString();
                    whereMap.put(fieldName, s + q.suffix());
                }
                String operate = q.operate().getValue();
                whereSql.append(" and ").append(value).append(" ").append(operate).append(":").append(fieldName);
            }
        }
    }

    private StringBuffer getSelectField() {
        Map<String, String> fieldMap = this.getFieldMap(true);
        StringBuffer sql = new StringBuffer(256);
        sql.append("select ");
        for (String value : fieldMap.values()) {
            sql.append(value).append(",");
        }
        sql.deleteCharAt(sql.length() - 1);
        sql.append(" from ").append(this.getTableName());
        return sql;
    }

    private String getTableName() {
        if (this.cls.isAnnotationPresent(Table.class)) {
            Table table = this.cls.getAnnotation(Table.class);
            return StrUtils.isBlank(table.name()) ? this.cls.getSimpleName() : table.name();
        }
        throw new TableNotFoundException("table not found");
    }

    private String getPrimaryKey() {
        return "id";
    }

    private Map<String, String> getFieldMap(boolean containsId) {
        Field[] declaredFields = ArrayUtils.addAll(BaseDO.class.getDeclaredFields(), this.cls.getDeclaredFields());
        LinkedHashMap<String, String> fieldMap = null;
        if (ArrayUtils.isNotEmpty(declaredFields)) {
            fieldMap = new LinkedHashMap<String, String>(declaredFields.length);
            for (Field field : declaredFields) {
                if (!field.isAnnotationPresent(Column.class)) continue;
                Column column = field.getAnnotation(Column.class);
                if (!containsId && column.isKey()) continue;
                fieldMap.put(field.getName(), StrUtils.isBlank(column.name()) ? field.getName() : column.name());
            }
        }
        if (CollectionUtils.isEmpty(fieldMap)) {
            throw new ColumnNotFoundException("column not found");
        }
        return fieldMap;
    }
}

