/*
 * Copyright 2019 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.github.nosan.boot.test.autoconfigure.cassandra;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

import org.springframework.boot.context.TypeExcludeFilter;
import org.springframework.boot.test.autoconfigure.filter.StandardAnnotationCustomizableTypeExcludeFilter;
import org.springframework.util.ClassUtils;

/**
 * {@link TypeExcludeFilter} for {@link DataCassandraTest @DataCassandraTest}.
 *
 * @author Dmytro Nosan
 */
class DataCassandraTypeExcludeFilter extends StandardAnnotationCustomizableTypeExcludeFilter<DataCassandraTest> {

	private static final Set<Class<?>> DEFAULT_INCLUDES;

	static {
		Set<Class<?>> includes = new LinkedHashSet<>();
		register(includes, "org.springframework.boot.autoconfigure.cassandra.ClusterBuilderCustomizer");
		register(includes, "org.springframework.boot.autoconfigure.cassandra.ClusterFactory");
		register(includes, "com.github.nosan.embedded.cassandra.api.CassandraFactoryCustomizer");
		DEFAULT_INCLUDES = Collections.unmodifiableSet(includes);
	}

	protected DataCassandraTypeExcludeFilter(Class<?> testClass) {
		super(testClass);
	}

	@Override
	protected Set<Class<?>> getDefaultIncludes() {
		return DEFAULT_INCLUDES;
	}

	private static void register(Set<Class<?>> includes, String className) {
		try {
			includes.add(ClassUtils.forName(className, DataCassandraTypeExcludeFilter.class.getClassLoader()));
		}
		catch (Throwable ex) {
			//ignore
		}
	}

}
