/*
 * Decompiled with CFR 0.152.
 */
package com.github.nosan.boot.test.autoconfigure.cassandra;

import com.datastax.driver.core.Cluster;
import com.github.nosan.embedded.cassandra.Cassandra;
import com.github.nosan.embedded.cassandra.Settings;
import com.github.nosan.embedded.cassandra.test.TestCassandra;
import java.net.InetAddress;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.cassandra.CassandraAutoConfiguration;
import org.springframework.boot.autoconfigure.cassandra.ClusterBuilderCustomizer;
import org.springframework.boot.autoconfigure.condition.AllNestedConditions;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.core.annotation.Order;
import org.springframework.core.type.AnnotatedTypeMetadata;

@Configuration
@AutoConfigureBefore(value={CassandraAutoConfiguration.class})
@ConditionalOnClass(value={Cluster.class, ClusterBuilderCustomizer.class})
public class EmbeddedCassandraClusterAutoConfiguration {

    @Configuration
    @ConditionalOnClass(value={DatabaseDescriptor.class})
    @Conditional(value={CassandraCondition.class})
    protected static class CassandraDaemonConfiguration {
        protected CassandraDaemonConfiguration() {
        }

        @Bean
        @Order(value=0)
        @Conditional(value={CassandraDaemonCondition.class})
        public ClusterBuilderCustomizer cassandraDaemonClusterBuilderCustomizer() {
            return builder -> {
                InetAddress rpcAddress = DatabaseDescriptor.getRpcAddress();
                int port = DatabaseDescriptor.getNativeTransportPort();
                builder.addContactPoints(new InetAddress[]{rpcAddress}).withPort(port);
            };
        }

        static class CassandraCondition
        extends AllNestedConditions {
            CassandraCondition() {
                super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
            }

            @ConditionalOnMissingBean(value={Cassandra.class})
            static class OnMissingCassandra {
                OnMissingCassandra() {
                }
            }

            @ConditionalOnMissingBean(value={TestCassandra.class})
            static class OnMissingTestCassandra {
                OnMissingTestCassandra() {
                }
            }
        }

        static class CassandraDaemonCondition
        extends SpringBootCondition {
            CassandraDaemonCondition() {
            }

            public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
                return DatabaseDescriptor.isDaemonInitialized() && DatabaseDescriptor.getRpcAddress() != null ? ConditionOutcome.match() : ConditionOutcome.noMatch((String)"Cassandra Daemon is not initialized.");
            }
        }
    }

    @Configuration
    @ConditionalOnClass(value={Cassandra.class})
    @ConditionalOnBean(value={Cassandra.class})
    @ConditionalOnMissingBean(value={TestCassandra.class})
    protected static class CassandraConfiguration {
        private final Cassandra cassandra;

        public CassandraConfiguration(Cassandra cassandra) {
            this.cassandra = cassandra;
        }

        @Bean
        @Order(value=0)
        public ClusterBuilderCustomizer cassandraClusterBuilderCustomizer() {
            return builder -> {
                Settings settings = this.cassandra.getSettings();
                builder.addContactPoints(new InetAddress[]{settings.getAddress()}).withPort(settings.getPort());
            };
        }
    }

    @Configuration
    @ConditionalOnClass(value={TestCassandra.class})
    @ConditionalOnBean(value={TestCassandra.class})
    protected static class TestCassandraConfiguration {
        private final TestCassandra cassandra;

        public TestCassandraConfiguration(TestCassandra cassandra) {
            this.cassandra = cassandra;
        }

        @Bean
        @Order(value=0)
        public ClusterBuilderCustomizer testCassandraClusterBuilderCustomizer() {
            return builder -> {
                Settings settings = this.cassandra.getSettings();
                builder.addContactPoints(new InetAddress[]{settings.getAddress()}).withPort(settings.getPort());
            };
        }
    }
}

