/*
 * Decompiled with CFR 0.152.
 */
package com.github.noconnor.junitperf.statistics.providers;

import com.github.noconnor.junitperf.statistics.StatisticsCalculator;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.apache.commons.math3.stat.descriptive.SynchronizedDescriptiveStatistics;

public class DescriptiveStatisticsCalculator
implements StatisticsCalculator {
    private final DescriptiveStatistics statistics;
    private final AtomicLong errorCount = new AtomicLong();
    private final AtomicLong evaluationCount = new AtomicLong();

    public DescriptiveStatisticsCalculator() {
        this((DescriptiveStatistics)new SynchronizedDescriptiveStatistics());
    }

    public DescriptiveStatisticsCalculator(int windowSize) {
        this((DescriptiveStatistics)new SynchronizedDescriptiveStatistics(windowSize));
    }

    public DescriptiveStatisticsCalculator(DescriptiveStatistics statistics) {
        this.statistics = statistics;
    }

    @Override
    public void addLatencyMeasurement(long executionTimeNs) {
        this.statistics.addValue((double)executionTimeNs);
    }

    @Override
    public void incrementErrorCount() {
        this.errorCount.incrementAndGet();
    }

    @Override
    public void incrementEvaluationCount() {
        this.evaluationCount.incrementAndGet();
    }

    @Override
    public long getErrorCount() {
        return this.errorCount.get();
    }

    @Override
    public long getEvaluationCount() {
        return this.evaluationCount.get();
    }

    @Override
    public float getLatencyPercentile(int percentile, TimeUnit unit) {
        float value = (float)this.statistics.getPercentile((double)percentile);
        return value > 0.0f ? value / (float)unit.toNanos(1L) : 0.0f;
    }

    @Override
    public float getMaxLatency(TimeUnit unit) {
        float max = (float)this.statistics.getMax();
        return max > 0.0f ? max / (float)unit.toNanos(1L) : 0.0f;
    }

    @Override
    public float getMinLatency(TimeUnit unit) {
        float min = (float)this.statistics.getMin();
        return min > 0.0f ? min / (float)unit.toNanos(1L) : 0.0f;
    }

    @Override
    public float getMeanLatency(TimeUnit unit) {
        float mean = (float)this.statistics.getMean();
        return mean > 0.0f ? mean / (float)unit.toNanos(1L) : 0.0f;
    }

    @Override
    public float getErrorPercentage() {
        float evalCount = this.evaluationCount.get();
        float errCount = this.errorCount.get();
        return evalCount > 0.0f ? errCount / evalCount * 100.0f : 0.0f;
    }

    @Override
    public void reset() {
        this.statistics.clear();
        this.evaluationCount.set(0L);
        this.errorCount.set(0L);
    }
}

