/*
 * Decompiled with CFR 0.152.
 */
package com.github.noconnor.junitperf.statements;

import com.github.noconnor.junitperf.data.EvaluationContext;
import com.github.noconnor.junitperf.statements.EvaluationTask;
import com.github.noconnor.junitperf.statements.TestStatement;
import com.github.noconnor.junitperf.statistics.StatisticsCalculator;
import com.github.noconnor.junitperf.statistics.providers.NoOpStatisticsCollector;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.RateLimiter;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;

public class PerformanceEvaluationStatement {
    private static final String THREAD_NAME_PATTERN = "perf-eval-thread-%d";
    private static final ThreadFactory FACTORY = new ThreadFactoryBuilder().setNameFormat("perf-eval-thread-%d").build();
    private final EvaluationContext context;
    private final ThreadFactory threadFactory;
    private final TestStatement baseStatement;
    private final StatisticsCalculator statistics;
    private final Consumer<Void> listener;
    private RateLimiter rateLimiter;

    private PerformanceEvaluationStatement(TestStatement baseStatement, StatisticsCalculator statistics, EvaluationContext context, ThreadFactory threadFactory, Consumer<Void> listener) {
        this.context = context;
        this.baseStatement = baseStatement;
        this.statistics = statistics;
        this.threadFactory = Objects.nonNull(threadFactory) ? threadFactory : FACTORY;
        this.rateLimiter = context.getConfiguredRateLimit() > 0 ? this.createRateLimiter(context) : null;
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runParallelEvaluation() throws Throwable {
        this.statistics.reset();
        ArrayList threads = Lists.newArrayList();
        AtomicBoolean stopSignal = new AtomicBoolean();
        CountDownLatch latch = new CountDownLatch(this.context.getConfiguredThreads());
        try {
            for (int i = 0; i < this.context.getConfiguredThreads(); ++i) {
                Thread t = this.threadFactory.newThread(this.createTask(stopSignal, latch));
                threads.add(t);
                t.start();
            }
            latch.await(this.context.getConfiguredDuration(), TimeUnit.MILLISECONDS);
        }
        finally {
            stopSignal.set(true);
            threads.forEach(Thread::interrupt);
        }
        if (this.context.isAborted()) {
            this.listener.accept(null);
            throw this.context.getAbortedException();
        }
        this.context.setFinishTimeNs(System.nanoTime());
        this.context.setStatistics(this.statistics);
        this.context.runValidation();
        this.listener.accept(null);
        this.assertThresholdsMet();
    }

    private Runnable createTask(AtomicBoolean stopSignal, CountDownLatch latch) {
        StatisticsCalculator stats = this.context.isAsyncEvaluation() ? NoOpStatisticsCollector.INSTANCE : this.statistics;
        return () -> {
            try {
                EvaluationTask.builder().statement(this.baseStatement).rateLimiter(this.rateLimiter).stats(stats).terminator(stopSignal::get).warmUpPeriodMs(this.context.getConfiguredWarmUp()).executionTarget(this.context.getConfiguredExecutionTarget()).build().run();
            }
            catch (Throwable t) {
                this.context.setAbortedException(t);
            }
            finally {
                latch.countDown();
            }
        };
    }

    private void assertThresholdsMet() {
        this.assertThat("Error threshold not achieved", this.context.isErrorThresholdAchieved(), true);
        this.assertThat("Test throughput threshold not achieved", this.context.isThroughputAchieved(), true);
        this.assertThat("Test min latency threshold not achieved", this.context.isMinLatencyAchieved(), true);
        this.assertThat("Test max latency threshold not achieved", this.context.isMaxLatencyAchieved(), true);
        this.assertThat("Test mean latency threshold not achieved", this.context.isMeanLatencyAchieved(), true);
        this.context.getPercentileResults().forEach((percentile, isAchieved) -> this.assertThat(String.format("%dth Percentile has not achieved required threshold", percentile), (boolean)isAchieved, true));
    }

    private RateLimiter createRateLimiter(EvaluationContext context) {
        int rampUp = context.getConfiguredRampUpPeriodMs();
        int rateLimit = context.getConfiguredRateLimit();
        return rampUp > 0 ? RateLimiter.create((double)rateLimit, (long)rampUp, (TimeUnit)TimeUnit.MILLISECONDS) : RateLimiter.create((double)rateLimit);
    }

    private void assertThat(String message, boolean actual, boolean expected) {
        if (actual != expected) {
            throw new AssertionError((Object)message);
        }
    }

    public static PerformanceEvaluationStatementBuilder builder() {
        return new PerformanceEvaluationStatementBuilder();
    }

    public static class PerformanceEvaluationStatementBuilder {
        private TestStatement baseStatement;
        private StatisticsCalculator statistics;
        private EvaluationContext context;
        private ThreadFactory threadFactory;
        private Consumer<Void> listener;

        PerformanceEvaluationStatementBuilder() {
        }

        public PerformanceEvaluationStatementBuilder baseStatement(TestStatement baseStatement) {
            this.baseStatement = baseStatement;
            return this;
        }

        public PerformanceEvaluationStatementBuilder statistics(StatisticsCalculator statistics) {
            this.statistics = statistics;
            return this;
        }

        public PerformanceEvaluationStatementBuilder context(EvaluationContext context) {
            this.context = context;
            return this;
        }

        public PerformanceEvaluationStatementBuilder threadFactory(ThreadFactory threadFactory) {
            this.threadFactory = threadFactory;
            return this;
        }

        public PerformanceEvaluationStatementBuilder listener(Consumer<Void> listener) {
            this.listener = listener;
            return this;
        }

        public PerformanceEvaluationStatement build() {
            return new PerformanceEvaluationStatement(this.baseStatement, this.statistics, this.context, this.threadFactory, this.listener);
        }

        public String toString() {
            return "PerformanceEvaluationStatement.PerformanceEvaluationStatementBuilder(baseStatement=" + this.baseStatement + ", statistics=" + this.statistics + ", context=" + this.context + ", threadFactory=" + this.threadFactory + ", listener=" + this.listener + ")";
        }
    }
}

