/*
 * Decompiled with CFR 0.152.
 */
package com.github.noconnor.junitperf.statements;

import com.github.noconnor.junitperf.statements.ExceptionsRegistry;
import com.github.noconnor.junitperf.statements.TestStatement;
import com.github.noconnor.junitperf.statistics.StatisticsCalculator;
import com.google.common.util.concurrent.RateLimiter;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class EvaluationTask
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(EvaluationTask.class);
    private final TestStatement statement;
    private final RateLimiter rateLimiter;
    private final Supplier<Boolean> terminator;
    private final StatisticsCalculator stats;
    private final long warmUpPeriodNs;
    private final long executionTarget;

    EvaluationTask(TestStatement statement, RateLimiter rateLimiter, StatisticsCalculator stats, Supplier<Boolean> terminator, int warmUpPeriodMs, int executionTarget) {
        this(statement, rateLimiter, terminator, stats, warmUpPeriodMs, executionTarget);
    }

    EvaluationTask(TestStatement statement, RateLimiter rateLimiter, Supplier<Boolean> terminator, StatisticsCalculator stats, int warmUpPeriodMs, int executionTarget) {
        this.statement = statement;
        this.rateLimiter = rateLimiter;
        this.terminator = terminator;
        this.stats = stats;
        this.warmUpPeriodNs = TimeUnit.NANOSECONDS.convert(Math.max(warmUpPeriodMs, 0), TimeUnit.MILLISECONDS);
        this.executionTarget = executionTarget;
    }

    @Override
    public void run() {
        long startTimeNs = System.nanoTime();
        long startMeasurements = startTimeNs + this.warmUpPeriodNs;
        while (this.terminationFlagNotSet() && EvaluationTask.threadNotInterrupted() && this.executionTargetNotMet()) {
            this.waitForPermit();
            this.evaluateStatement(startMeasurements);
        }
    }

    private boolean terminationFlagNotSet() {
        return this.terminator.get() == false;
    }

    private static boolean threadNotInterrupted() {
        return !Thread.currentThread().isInterrupted();
    }

    private boolean executionTargetNotMet() {
        return this.executionTarget <= 0L || this.stats.getEvaluationCount() < this.executionTarget;
    }

    private void evaluateStatement(long startMeasurements) throws Throwable {
        block15: {
            if (System.nanoTime() < startMeasurements) {
                try {
                    this.statement.runBefores();
                    this.statement.evaluate();
                    this.statement.runAfters();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (Throwable throwable) {
                    log.trace("Warmup error", throwable);
                }
            } else {
                block14: {
                    try {
                        this.statement.runBefores();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    catch (Throwable throwable) {
                        log.trace("Setup error", throwable);
                        ExceptionsRegistry.reThrowIfAbort(throwable);
                        if (!this.isTerminalException(throwable)) break block14;
                        throw new IllegalStateException("Before method failed", throwable);
                    }
                }
                long startTimeNs = System.nanoTime();
                try {
                    this.statement.evaluate();
                    this.stats.addLatencyMeasurement(System.nanoTime() - startTimeNs);
                    this.stats.incrementEvaluationCount();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (Throwable throwable) {
                    log.trace("Execution error", throwable);
                    ExceptionsRegistry.reThrowIfAbort(throwable);
                    this.checkForIgnorable(throwable);
                    this.stats.addLatencyMeasurement(System.nanoTime() - startTimeNs);
                }
                try {
                    this.statement.runAfters();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (Throwable throwable) {
                    log.trace("Teardown error", throwable);
                    ExceptionsRegistry.reThrowIfAbort(throwable);
                    if (!this.isTerminalException(throwable)) break block15;
                    throw new IllegalStateException("After method failed", throwable);
                }
            }
        }
    }

    private void checkForIgnorable(Throwable throwable) {
        if (this.isIgnorableException(throwable)) {
            this.stats.incrementEvaluationCount();
        } else {
            this.stats.incrementEvaluationCount();
            this.stats.incrementErrorCount();
        }
    }

    private boolean isTerminalException(Throwable throwable) {
        return !this.isIgnorableException(throwable);
    }

    private boolean isIgnorableException(Throwable throwable) {
        return this.isIgnorable(throwable);
    }

    private boolean isIgnorable(Throwable throwable) {
        if (Objects.isNull(throwable)) {
            return false;
        }
        return ExceptionsRegistry.isIgnorable(throwable) || this.isIgnorable(throwable.getCause());
    }

    private void waitForPermit() {
        if (Objects.nonNull(this.rateLimiter)) {
            this.rateLimiter.acquire();
        }
    }

    public static EvaluationTaskBuilder builder() {
        return new EvaluationTaskBuilder();
    }

    public static class EvaluationTaskBuilder {
        private TestStatement statement;
        private RateLimiter rateLimiter;
        private StatisticsCalculator stats;
        private Supplier<Boolean> terminator;
        private int warmUpPeriodMs;
        private int executionTarget;

        EvaluationTaskBuilder() {
        }

        public EvaluationTaskBuilder statement(TestStatement statement) {
            this.statement = statement;
            return this;
        }

        public EvaluationTaskBuilder rateLimiter(RateLimiter rateLimiter) {
            this.rateLimiter = rateLimiter;
            return this;
        }

        public EvaluationTaskBuilder stats(StatisticsCalculator stats) {
            this.stats = stats;
            return this;
        }

        public EvaluationTaskBuilder terminator(Supplier<Boolean> terminator) {
            this.terminator = terminator;
            return this;
        }

        public EvaluationTaskBuilder warmUpPeriodMs(int warmUpPeriodMs) {
            this.warmUpPeriodMs = warmUpPeriodMs;
            return this;
        }

        public EvaluationTaskBuilder executionTarget(int executionTarget) {
            this.executionTarget = executionTarget;
            return this;
        }

        public EvaluationTask build() {
            return new EvaluationTask(this.statement, this.rateLimiter, this.stats, this.terminator, this.warmUpPeriodMs, this.executionTarget);
        }

        public String toString() {
            return "EvaluationTask.EvaluationTaskBuilder(statement=" + this.statement + ", rateLimiter=" + this.rateLimiter + ", stats=" + this.stats + ", terminator=" + this.terminator + ", warmUpPeriodMs=" + this.warmUpPeriodMs + ", executionTarget=" + this.executionTarget + ")";
        }
    }
}

