/*
 * Decompiled with CFR 0.152.
 */
package com.github.noconnor.junitperf.reporting.providers.utils;

import com.github.noconnor.junitperf.data.EvaluationContext;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class ViewData {
    static final String SUCCESS_COLOUR = "#2b67a4";
    static final String FAILED_COLOUR = "#d9534f";
    static final String SKIPPED_COLOUR = "#dcdcdc";
    private final String testName;
    private final String uniqueId;
    private final String testNameColour;
    private final String chartData;
    private final String csvData;
    private final String startTime;
    private final String totalInvocations;
    private final String successfulInvocations;
    private final String errorThresholdColour;
    private final String errorCount;
    private final String errorPercentage;
    private final String configuredThreads;
    private final String configuredWarmUp;
    private final String configuredRampUpPeriodMs;
    private final String testDurationFormatted;
    private final String throughputAchievedColour;
    private final String throughputQps;
    private final String requiredThroughput;
    private final String minLatencyAchievedColour;
    private final String requiredMinLatency;
    private final String minLatency;
    private final String meanLatencyAchievedColour;
    private final String meanLatency;
    private final String requiredMeanLatency;
    private final String maxLatencyAchievedColour;
    private final String maxLatency;
    private final String requiredMaxLatency;
    private final List<RequiredPercentilesData> requiredPercentiles;

    public ViewData(EvaluationContext context) {
        this.testName = ViewData.buildTestName(context);
        this.uniqueId = context.getUniqueId();
        this.testNameColour = context.isAborted() ? SKIPPED_COLOUR : (context.isSuccessful() ? SUCCESS_COLOUR : FAILED_COLOUR);
        this.chartData = ViewData.buildChartData(context);
        this.csvData = ViewData.buildCsvData(context);
        this.startTime = context.getStartTime();
        this.totalInvocations = ViewData.formatNumber(context.getEvaluationCount(), 0, ",");
        this.successfulInvocations = ViewData.formatNumber(context.getEvaluationCount() - context.getErrorCount(), 0, ",");
        this.errorThresholdColour = context.isErrorThresholdAchieved() ? SUCCESS_COLOUR : FAILED_COLOUR;
        this.errorCount = ViewData.formatNumber(context.getErrorCount(), 0, ",");
        this.errorPercentage = ViewData.formatNumber(context.getErrorPercentage(), 2, ",");
        this.configuredThreads = String.valueOf(context.getConfiguredThreads());
        this.configuredWarmUp = ViewData.formatNumber(context.getConfiguredWarmUp(), 0, ",");
        this.configuredRampUpPeriodMs = ViewData.formatNumber(context.getConfiguredRampUpPeriodMs(), 0, ",");
        this.testDurationFormatted = context.getTestDurationFormatted();
        this.throughputAchievedColour = context.isThroughputAchieved() ? SUCCESS_COLOUR : FAILED_COLOUR;
        this.throughputQps = ViewData.formatNumber(context.getThroughputQps(), 0, ",");
        this.requiredThroughput = ViewData.formatNumber(context.getRequiredThroughput(), 0, ",");
        this.minLatencyAchievedColour = context.isMinLatencyAchieved() ? SUCCESS_COLOUR : FAILED_COLOUR;
        this.requiredMinLatency = context.getRequiredMinLatency() < 0.0f ? "N/A" : ViewData.formatNumber(context.getRequiredMinLatency(), 2, "");
        this.minLatency = ViewData.formatNumber(context.getMinLatencyMs(), 2, " ");
        this.meanLatencyAchievedColour = context.isMeanLatencyAchieved() ? SUCCESS_COLOUR : FAILED_COLOUR;
        this.meanLatency = ViewData.formatNumber(context.getMeanLatencyMs(), 2, " ");
        this.requiredMeanLatency = context.getRequiredMeanLatency() < 0.0f ? "N/A" : ViewData.formatNumber(context.getRequiredMeanLatency(), 2, "");
        this.maxLatencyAchievedColour = context.isMaxLatencyAchieved() ? SUCCESS_COLOUR : FAILED_COLOUR;
        this.maxLatency = ViewData.formatNumber(context.getMaxLatencyMs(), 2, ",");
        this.requiredMaxLatency = context.getRequiredMaxLatency() < 0.0f ? "N/A" : ViewData.formatNumber(context.getRequiredMaxLatency(), 2, "");
        this.requiredPercentiles = this.buildRequiredPercentileData(context);
    }

    private static String buildTestName(EvaluationContext context) {
        String baseName;
        String string = baseName = Objects.nonNull(context.getGroupName()) ? context.getGroupName() + " : " + context.getTestName() : context.getTestName();
        if (context.isAborted()) {
            baseName = baseName + " (skipped)";
        }
        return baseName;
    }

    private List<RequiredPercentilesData> buildRequiredPercentileData(EvaluationContext context) {
        if (Objects.isNull(context.getPercentileResults())) {
            return Collections.emptyList();
        }
        return context.getRequiredPercentiles().entrySet().stream().map(entry -> {
            Integer percentile = (Integer)entry.getKey();
            Float target = (Float)entry.getValue();
            RequiredPercentilesData data = new RequiredPercentilesData();
            data.percentile = percentile.toString();
            data.percentileResultColour = context.getPercentileResults().get(percentile) != false ? SUCCESS_COLOUR : FAILED_COLOUR;
            data.percentileLatency = ViewData.formatNumber(context.getLatencyPercentileMs(percentile), 2, ",");
            data.percentileTarget = ViewData.formatNumber(target.floatValue(), 2, ",");
            return data;
        }).collect(Collectors.toList());
    }

    private static String buildCsvData(EvaluationContext context) {
        return IntStream.range(1, 101).mapToObj(i -> "[ " + i + ", " + context.getLatencyPercentileMs(i) + " ],").collect(Collectors.joining("\n"));
    }

    private static String buildChartData(EvaluationContext context) {
        return IntStream.range(1, 100).mapToObj(i -> "[ " + i + ", " + context.getLatencyPercentileMs(i) + ", \"" + i + "% of executions \u2264 " + ViewData.formatNumber(context.getLatencyPercentileMs(i), 2, ",") + "ms\"],").collect(Collectors.joining("\n"));
    }

    private static String formatNumber(float value, int decimalPlaces, String thousandSeparator) {
        return String.format("%" + thousandSeparator + "." + decimalPlaces + "f", Float.valueOf(value)).trim();
    }

    public String getTestName() {
        return this.testName;
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public String getTestNameColour() {
        return this.testNameColour;
    }

    public String getChartData() {
        return this.chartData;
    }

    public String getCsvData() {
        return this.csvData;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public String getTotalInvocations() {
        return this.totalInvocations;
    }

    public String getSuccessfulInvocations() {
        return this.successfulInvocations;
    }

    public String getErrorThresholdColour() {
        return this.errorThresholdColour;
    }

    public String getErrorCount() {
        return this.errorCount;
    }

    public String getErrorPercentage() {
        return this.errorPercentage;
    }

    public String getConfiguredThreads() {
        return this.configuredThreads;
    }

    public String getConfiguredWarmUp() {
        return this.configuredWarmUp;
    }

    public String getConfiguredRampUpPeriodMs() {
        return this.configuredRampUpPeriodMs;
    }

    public String getTestDurationFormatted() {
        return this.testDurationFormatted;
    }

    public String getThroughputAchievedColour() {
        return this.throughputAchievedColour;
    }

    public String getThroughputQps() {
        return this.throughputQps;
    }

    public String getRequiredThroughput() {
        return this.requiredThroughput;
    }

    public String getMinLatencyAchievedColour() {
        return this.minLatencyAchievedColour;
    }

    public String getRequiredMinLatency() {
        return this.requiredMinLatency;
    }

    public String getMinLatency() {
        return this.minLatency;
    }

    public String getMeanLatencyAchievedColour() {
        return this.meanLatencyAchievedColour;
    }

    public String getMeanLatency() {
        return this.meanLatency;
    }

    public String getRequiredMeanLatency() {
        return this.requiredMeanLatency;
    }

    public String getMaxLatencyAchievedColour() {
        return this.maxLatencyAchievedColour;
    }

    public String getMaxLatency() {
        return this.maxLatency;
    }

    public String getRequiredMaxLatency() {
        return this.requiredMaxLatency;
    }

    public List<RequiredPercentilesData> getRequiredPercentiles() {
        return this.requiredPercentiles;
    }

    public static final class RequiredPercentilesData {
        private String percentile;
        private String percentileResultColour;
        private String percentileLatency;
        private String percentileTarget;

        public String getPercentile() {
            return this.percentile;
        }

        public String getPercentileResultColour() {
            return this.percentileResultColour;
        }

        public String getPercentileLatency() {
            return this.percentileLatency;
        }

        public String getPercentileTarget() {
            return this.percentileTarget;
        }

        public void setPercentile(String percentile) {
            this.percentile = percentile;
        }

        public void setPercentileResultColour(String percentileResultColour) {
            this.percentileResultColour = percentileResultColour;
        }

        public void setPercentileLatency(String percentileLatency) {
            this.percentileLatency = percentileLatency;
        }

        public void setPercentileTarget(String percentileTarget) {
            this.percentileTarget = percentileTarget;
        }

        public String toString() {
            return "ViewData.RequiredPercentilesData(percentile=" + this.getPercentile() + ", percentileResultColour=" + this.getPercentileResultColour() + ", percentileLatency=" + this.getPercentileLatency() + ", percentileTarget=" + this.getPercentileTarget() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RequiredPercentilesData)) {
                return false;
            }
            RequiredPercentilesData other = (RequiredPercentilesData)o;
            String this$percentile = this.getPercentile();
            String other$percentile = other.getPercentile();
            if (this$percentile == null ? other$percentile != null : !this$percentile.equals(other$percentile)) {
                return false;
            }
            String this$percentileResultColour = this.getPercentileResultColour();
            String other$percentileResultColour = other.getPercentileResultColour();
            if (this$percentileResultColour == null ? other$percentileResultColour != null : !this$percentileResultColour.equals(other$percentileResultColour)) {
                return false;
            }
            String this$percentileLatency = this.getPercentileLatency();
            String other$percentileLatency = other.getPercentileLatency();
            if (this$percentileLatency == null ? other$percentileLatency != null : !this$percentileLatency.equals(other$percentileLatency)) {
                return false;
            }
            String this$percentileTarget = this.getPercentileTarget();
            String other$percentileTarget = other.getPercentileTarget();
            return !(this$percentileTarget == null ? other$percentileTarget != null : !this$percentileTarget.equals(other$percentileTarget));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $percentile = this.getPercentile();
            result = result * 59 + ($percentile == null ? 43 : $percentile.hashCode());
            String $percentileResultColour = this.getPercentileResultColour();
            result = result * 59 + ($percentileResultColour == null ? 43 : $percentileResultColour.hashCode());
            String $percentileLatency = this.getPercentileLatency();
            result = result * 59 + ($percentileLatency == null ? 43 : $percentileLatency.hashCode());
            String $percentileTarget = this.getPercentileTarget();
            result = result * 59 + ($percentileTarget == null ? 43 : $percentileTarget.hashCode());
            return result;
        }
    }
}

