/*
 * Decompiled with CFR 0.152.
 */
package com.github.noconnor.junitperf.reporting.providers;

import com.github.noconnor.junitperf.data.EvaluationContext;
import com.github.noconnor.junitperf.reporting.ReportGenerator;
import com.github.noconnor.junitperf.reporting.providers.utils.ViewData;
import com.github.noconnor.junitperf.reporting.providers.utils.ViewProcessor;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Scanner;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HtmlReportGenerator
implements ReportGenerator {
    private static final Logger log = LoggerFactory.getLogger(HtmlReportGenerator.class);
    private static final String DEFAULT_REPORT_PATH = String.join((CharSequence)File.separator, System.getProperty("user.dir"), "build", "reports", "junitperf_report.html");
    private static final String REPORT_TEMPLATE = "/templates/report.template";
    private static final String OVERVIEW_MARKER = "{% OVERVIEW_BLOCK %}";
    private static final String DETAILS_MARKER = "{% DETAILED_BLOCK %}";
    private static final String PERCENTILE_TARGETS_MARKER = "{% PERCENTILES_BLOCK %}";
    private final String reportPath;
    private final Set<EvaluationContext> history;

    public HtmlReportGenerator() {
        this(DEFAULT_REPORT_PATH);
    }

    public HtmlReportGenerator(String reportPath) {
        this.reportPath = reportPath;
        this.history = new LinkedHashSet<EvaluationContext>();
    }

    @Override
    public synchronized void generateReport(LinkedHashSet<EvaluationContext> testContexts) {
        this.history.addAll(testContexts);
        this.renderTemplate();
    }

    @Override
    public String getReportPath() {
        return this.reportPath;
    }

    private void renderTemplate() {
        try {
            Path outputPath = Paths.get(this.reportPath, new String[0]);
            Files.createDirectories(outputPath.getParent(), new FileAttribute[0]);
            log.info("Rendering report to: " + outputPath);
            Map<String, String> blocks = HtmlTemplateProcessor.parseTemplateBlocks();
            String root = blocks.get("root");
            StringBuilder overviews = new StringBuilder();
            StringBuilder details = new StringBuilder();
            for (EvaluationContext context : this.history) {
                ViewData c = new ViewData(context);
                String overview = ViewProcessor.populateTemplate(c, "context", blocks.get(OVERVIEW_MARKER));
                if (context.isAborted()) {
                    overview = overview.replaceAll("href=", "nolink=");
                } else {
                    String detail = ViewProcessor.populateTemplate(c, "context", blocks.get(DETAILS_MARKER));
                    String percentileData = ViewProcessor.populateTemplate(c.getRequiredPercentiles(), "context.percentiles", blocks.get(PERCENTILE_TARGETS_MARKER));
                    detail = detail.replaceAll(this.asRegex(PERCENTILE_TARGETS_MARKER), percentileData);
                    details.append(detail).append("\n");
                }
                overviews.append(overview).append("\n");
            }
            root = root.replaceAll(this.asRegex(OVERVIEW_MARKER), overviews.toString());
            root = root.replaceAll(this.asRegex(DETAILS_MARKER), details.toString());
            Files.write(outputPath, root.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private String asRegex(String marker) {
        return marker.replaceAll("\\{", "\\\\{").replaceAll("\\}", "\\\\}");
    }

    public static final class HtmlTemplateProcessor {
        final /* synthetic */ HtmlReportGenerator this$0;

        public static Map<String, String> parseTemplateBlocks() {
            InputStream templateString = HtmlTemplateProcessor.class.getResourceAsStream(HtmlReportGenerator.REPORT_TEMPLATE);
            if (Objects.isNull(templateString)) {
                throw new IllegalStateException("Report template is missing: /templates/report.template");
            }
            HashMap<String, StringBuilder> contextBlocks = new HashMap<String, StringBuilder>();
            ArrayDeque<StringBuilder> stack = new ArrayDeque<StringBuilder>();
            StringBuilder root = new StringBuilder();
            stack.push(root);
            contextBlocks.put("root", root);
            HashSet<String> expectedBlocks = new HashSet<String>();
            expectedBlocks.add(HtmlReportGenerator.OVERVIEW_MARKER);
            expectedBlocks.add(HtmlReportGenerator.DETAILS_MARKER);
            expectedBlocks.add(HtmlReportGenerator.PERCENTILE_TARGETS_MARKER);
            try (Scanner scanner = new Scanner(templateString);){
                while (scanner.hasNext()) {
                    String line = scanner.nextLine();
                    String trimmed = line.trim();
                    if (expectedBlocks.contains(trimmed)) {
                        ((StringBuilder)stack.getFirst()).append(line).append("\n");
                        StringBuilder newBlock = new StringBuilder();
                        contextBlocks.put(trimmed, newBlock);
                        stack.push(newBlock);
                        continue;
                    }
                    if (trimmed.equals("{% END %}")) {
                        stack.pop();
                        continue;
                    }
                    ((StringBuilder)stack.getFirst()).append(line).append("\n");
                }
            }
            return contextBlocks.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((StringBuilder)e.getValue()).toString()));
        }

        private HtmlTemplateProcessor(HtmlReportGenerator htmlReportGenerator) {
            this.this$0 = htmlReportGenerator;
            throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
        }
    }
}

