/*
 * Decompiled with CFR 0.152.
 */
package com.github.noconnor.junitperf.datetime;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;

public final class DatetimeUtils {
    private static String override;

    public static String now() {
        if (Objects.nonNull(override)) {
            return override;
        }
        return LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
    }

    public static String format(int durationMs) {
        long seconds = durationMs / 1000;
        long minutes = seconds / 60L;
        long hours = minutes / 60L;
        long days = hours / 24L;
        if (days > 0L) {
            return days + "d:" + hours % 24L + "h:" + minutes % 60L + "m:" + seconds % 60L + "s";
        }
        if (hours > 0L) {
            return hours % 24L + "h:" + minutes % 60L + "m:" + seconds % 60L + "s";
        }
        if (minutes > 0L) {
            return minutes % 60L + "m:" + seconds % 60L + "s";
        }
        if (seconds > 0L) {
            return seconds % 60L + "s";
        }
        return durationMs + "ms";
    }

    private DatetimeUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static void setOverride(String override) {
        DatetimeUtils.override = override;
    }
}

