/*
 * Decompiled with CFR 0.152.
 */
package com.github.noconnor.junitperf.data;

import com.github.noconnor.junitperf.JUnitPerfTest;
import com.github.noconnor.junitperf.JUnitPerfTestRequirement;
import com.github.noconnor.junitperf.datetime.DatetimeUtils;
import com.github.noconnor.junitperf.statistics.StatisticsCalculator;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.primitives.Floats;
import com.google.common.primitives.Ints;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvaluationContext {
    private static final Logger log = LoggerFactory.getLogger(EvaluationContext.class);
    static final String JUNITPERF_THREADS = "junitperf.threads";
    static final String JUNITPERF_WARM_UP_MS = "junitperf.warmUpMs";
    static final String JUNITPERF_DURATION_MS = "junitperf.durationMs";
    static final String JUNITPERF_RAMP_UP_PERIOD_MS = "junitperf.rampUpPeriodMs";
    static final String JUNITPERF_TOTAL_EXECUTIONS = "junitperf.totalExecutions";
    static final String JUNITPERF_MAX_EXECUTIONS_PER_SECOND = "junitperf.maxExecutionsPerSecond";
    private int configuredThreads;
    private int configuredDuration;
    private int configuredWarmUp;
    private int configuredRateLimit;
    private int configuredRampUpPeriodMs;
    private int configuredExecutionTarget;
    private final long startTimeNs;
    private long finishTimeNs;
    private final boolean isAsyncEvaluation;
    private Throwable abortedException;
    private Map<Integer, Float> requiredPercentiles = Collections.emptyMap();
    private int requiredThroughput = 0;
    private float requiredAllowedErrorsRate = 0.0f;
    private float requiredMinLatency = -1.0f;
    private float requiredMaxLatency = -1.0f;
    private float requiredMeanLatency = -1.0f;
    private StatisticsCalculator statistics;
    private boolean isThroughputAchieved;
    private boolean isMinLatencyAchieved;
    private boolean isMaxLatencyAchieved;
    private boolean isMeanLatencyAchieved;
    private boolean isErrorThresholdAchieved;
    private Map<Integer, Boolean> percentileResults;
    private boolean isSuccessful;
    private final float[] percentiles = new float[101];
    private float minLatencyMs;
    private float maxLatencyMs;
    private float meanLatencyMs;
    private float errorPercentage;
    private long evaluationCount;
    private long errorCount;
    private final String testName;
    private final String startTime;
    private String groupName;
    private final String uniqueId;

    public EvaluationContext(String testName, long startTimeNs) {
        this(String.valueOf(System.nanoTime()), testName, startTimeNs);
    }

    public EvaluationContext(String testName, long startTimeNs, boolean isAsyncEvaluation) {
        this(String.valueOf(System.nanoTime()), testName, startTimeNs, isAsyncEvaluation);
    }

    public EvaluationContext(String uniqueId, String testName, long startTimeNs) {
        this(uniqueId, testName, startTimeNs, false);
    }

    public EvaluationContext(String uniqueId, String testName, long startTimeNs, boolean isAsyncEvaluation) {
        this.uniqueId = testName + "_" + uniqueId;
        this.testName = testName;
        this.startTimeNs = startTimeNs;
        this.startTime = DatetimeUtils.now();
        this.isAsyncEvaluation = isAsyncEvaluation;
    }

    public boolean isAborted() {
        return Objects.nonNull(this.abortedException);
    }

    public long getThroughputQps() {
        return (long)((float)this.evaluationCount / ((float)this.configuredDuration - (float)this.configuredWarmUp) * 1000.0f);
    }

    public float getLatencyPercentileMs(int percentile) {
        return this.percentiles[percentile];
    }

    public String getTestDurationFormatted() {
        long timeTakenMs = TimeUnit.MILLISECONDS.convert(this.finishTimeNs - this.startTimeNs, TimeUnit.NANOSECONDS);
        return DatetimeUtils.format((int)timeTakenMs);
    }

    public void loadConfiguration(JUnitPerfTest testSettings) {
        Preconditions.checkNotNull((Object)testSettings, (Object)"Test settings must not be null");
        this.configuredThreads = this.checkForEnvOverride(JUNITPERF_THREADS, testSettings.threads());
        this.configuredDuration = this.checkForEnvOverride(JUNITPERF_DURATION_MS, testSettings.durationMs());
        this.configuredWarmUp = this.checkForEnvOverride(JUNITPERF_WARM_UP_MS, testSettings.warmUpMs());
        this.configuredRateLimit = this.checkForEnvOverride(JUNITPERF_MAX_EXECUTIONS_PER_SECOND, testSettings.maxExecutionsPerSecond());
        this.configuredRampUpPeriodMs = this.checkForEnvOverride(JUNITPERF_RAMP_UP_PERIOD_MS, testSettings.rampUpPeriodMs());
        this.configuredExecutionTarget = this.checkForEnvOverride(JUNITPERF_TOTAL_EXECUTIONS, testSettings.totalExecutions());
        this.validateTestSettings();
    }

    public void loadRequirements(JUnitPerfTestRequirement requirements) {
        if (Objects.nonNull(requirements)) {
            this.requiredThroughput = requirements.executionsPerSec();
            this.requiredAllowedErrorsRate = requirements.allowedErrorPercentage();
            this.requiredPercentiles = EvaluationContext.parsePercentileLimits(requirements.percentiles());
            this.requiredMinLatency = requirements.minLatency();
            this.requiredMaxLatency = requirements.maxLatency();
            this.requiredMeanLatency = requirements.meanLatency();
            this.validateRequirements();
        }
    }

    public void runValidation() {
        Preconditions.checkState((boolean)Objects.nonNull(this.statistics), (Object)"Statistics must be calculated before running validation");
        this.calculateAndCacheStatistics();
        this.isThroughputAchieved = this.getThroughputQps() >= (long)this.requiredThroughput;
        this.isErrorThresholdAchieved = this.errorPercentage <= this.requiredAllowedErrorsRate * 100.0f;
        this.isMinLatencyAchieved = this.validateLatency(this.minLatencyMs, this.requiredMinLatency);
        this.isMaxLatencyAchieved = this.validateLatency(this.maxLatencyMs, this.requiredMaxLatency);
        this.isMeanLatencyAchieved = this.validateLatency(this.meanLatencyMs, this.requiredMeanLatency);
        this.percentileResults = this.evaluateLatencyPercentiles();
        this.isSuccessful = this.isThroughputAchieved && this.isMaxLatencyAchieved && this.isMinLatencyAchieved && this.isMeanLatencyAchieved && this.isErrorThresholdAchieved && this.noLatencyPercentileFailures();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EvaluationContext context = (EvaluationContext)o;
        return Objects.equals(this.testName, context.testName) && Objects.equals(this.groupName, context.groupName) && Objects.equals(this.uniqueId, context.uniqueId);
    }

    public int hashCode() {
        return Objects.hash(this.testName, this.groupName, this.uniqueId);
    }

    private boolean validateLatency(float actualMs, float requiredMs) {
        return requiredMs < 0.0f || actualMs <= requiredMs;
    }

    private boolean noLatencyPercentileFailures() {
        return this.percentileResults.values().stream().allMatch(e -> e);
    }

    private Map<Integer, Boolean> evaluateLatencyPercentiles() {
        TreeMap results = Maps.newTreeMap();
        this.requiredPercentiles.forEach((percentile, thresholdMs) -> {
            boolean result = this.getLatencyPercentileMs((int)percentile) <= thresholdMs.floatValue();
            results.put(percentile, result);
        });
        return results;
    }

    private static Map<Integer, Float> parsePercentileLimits(String percentileLimits) {
        TreeMap limits = Maps.newTreeMap();
        if (StringUtils.isNotBlank((CharSequence)percentileLimits)) {
            Stream.of(percentileLimits.split(",")).map(entry -> entry.split(":")).filter(entry -> ((String[])entry).length == 2).map(entry -> ImmutablePair.of((Object)Ints.tryParse((String)entry[0]), (Object)Floats.tryParse((String)entry[1]))).filter(entry -> Objects.nonNull(entry.getLeft()) && Objects.nonNull(entry.getRight())).forEach(entry -> limits.put((Integer)entry.getLeft(), (Float)entry.getRight()));
        }
        return limits;
    }

    private void validateTestSettings() {
        Preconditions.checkState((this.configuredDuration > 0 ? 1 : 0) != 0, (Object)"DurationMs must be greater than 0ms");
        Preconditions.checkState((this.configuredRampUpPeriodMs >= 0 ? 1 : 0) != 0, (Object)"RampUpPeriodMs must be >= 0ms");
        Preconditions.checkState((this.configuredRampUpPeriodMs < this.configuredDuration ? 1 : 0) != 0, (Object)"RampUpPeriodMs must be < DurationMs");
        Preconditions.checkState((this.configuredWarmUp >= 0 ? 1 : 0) != 0, (Object)"WarmUpMs must be >= 0ms");
        Preconditions.checkState((this.configuredWarmUp < this.configuredDuration ? 1 : 0) != 0, (Object)"WarmUpMs must be < DurationMs");
        Preconditions.checkState((this.configuredThreads > 0 ? 1 : 0) != 0, (Object)"Threads must be > 0");
        Preconditions.checkState((this.configuredRateLimit > 0 || this.configuredRateLimit == -1 ? 1 : 0) != 0, (Object)"MaxExecutionsPerSecond must be > 0 or -1 (to disable)");
    }

    private void validateRequirements() {
        Preconditions.checkState((this.requiredAllowedErrorsRate >= 0.0f ? 1 : 0) != 0, (Object)"AllowedErrorPercentage must be >= 0");
        Preconditions.checkState((this.requiredThroughput >= 0 ? 1 : 0) != 0, (Object)"ExecutionsPerSec must be >= 0");
    }

    private void calculateAndCacheStatistics() {
        IntStream.range(1, 101).forEach(i -> {
            this.percentiles[i] = this.statistics.getLatencyPercentile(i, TimeUnit.MILLISECONDS);
        });
        this.minLatencyMs = this.statistics.getMinLatency(TimeUnit.MILLISECONDS);
        this.maxLatencyMs = this.statistics.getMaxLatency(TimeUnit.MILLISECONDS);
        this.meanLatencyMs = this.statistics.getMeanLatency(TimeUnit.MILLISECONDS);
        this.errorPercentage = this.statistics.getErrorPercentage();
        this.errorCount = this.statistics.getErrorCount();
        this.evaluationCount = this.statistics.getEvaluationCount();
    }

    private int checkForEnvOverride(String name, int defaultValue) {
        Integer override = Integer.getInteger(name);
        if (Objects.nonNull(override)) {
            log.info("Using -D{} override: {}", (Object)name, (Object)override);
            return override;
        }
        return defaultValue;
    }

    public int getConfiguredThreads() {
        return this.configuredThreads;
    }

    public int getConfiguredDuration() {
        return this.configuredDuration;
    }

    public int getConfiguredWarmUp() {
        return this.configuredWarmUp;
    }

    public int getConfiguredRateLimit() {
        return this.configuredRateLimit;
    }

    public int getConfiguredRampUpPeriodMs() {
        return this.configuredRampUpPeriodMs;
    }

    public int getConfiguredExecutionTarget() {
        return this.configuredExecutionTarget;
    }

    public long getStartTimeNs() {
        return this.startTimeNs;
    }

    public long getFinishTimeNs() {
        return this.finishTimeNs;
    }

    public void setFinishTimeNs(long finishTimeNs) {
        this.finishTimeNs = finishTimeNs;
    }

    public boolean isAsyncEvaluation() {
        return this.isAsyncEvaluation;
    }

    public void setAbortedException(Throwable abortedException) {
        this.abortedException = abortedException;
    }

    public Throwable getAbortedException() {
        return this.abortedException;
    }

    public Map<Integer, Float> getRequiredPercentiles() {
        return this.requiredPercentiles;
    }

    public int getRequiredThroughput() {
        return this.requiredThroughput;
    }

    public float getRequiredAllowedErrorsRate() {
        return this.requiredAllowedErrorsRate;
    }

    public float getRequiredMinLatency() {
        return this.requiredMinLatency;
    }

    public float getRequiredMaxLatency() {
        return this.requiredMaxLatency;
    }

    public float getRequiredMeanLatency() {
        return this.requiredMeanLatency;
    }

    public void setStatistics(StatisticsCalculator statistics) {
        this.statistics = statistics;
    }

    public boolean isThroughputAchieved() {
        return this.isThroughputAchieved;
    }

    public boolean isMinLatencyAchieved() {
        return this.isMinLatencyAchieved;
    }

    public boolean isMaxLatencyAchieved() {
        return this.isMaxLatencyAchieved;
    }

    public boolean isMeanLatencyAchieved() {
        return this.isMeanLatencyAchieved;
    }

    public boolean isErrorThresholdAchieved() {
        return this.isErrorThresholdAchieved;
    }

    public Map<Integer, Boolean> getPercentileResults() {
        return this.percentileResults;
    }

    public boolean isSuccessful() {
        return this.isSuccessful;
    }

    public float[] getPercentiles() {
        return this.percentiles;
    }

    public float getMinLatencyMs() {
        return this.minLatencyMs;
    }

    public float getMaxLatencyMs() {
        return this.maxLatencyMs;
    }

    public float getMeanLatencyMs() {
        return this.meanLatencyMs;
    }

    public float getErrorPercentage() {
        return this.errorPercentage;
    }

    public long getEvaluationCount() {
        return this.evaluationCount;
    }

    public long getErrorCount() {
        return this.errorCount;
    }

    public String getTestName() {
        return this.testName;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public String getUniqueId() {
        return this.uniqueId;
    }
}

