/*
 * Decompiled with CFR 0.152.
 */
package com.github.nicosensei.batch.elasticsearch;

import com.github.nicosensei.batch.BatchException;
import com.github.nicosensei.batch.BatchExecutor;
import com.github.nicosensei.batch.BatchState;
import com.github.nicosensei.batch.Worker;
import com.github.nicosensei.batch.elasticsearch.DocumentBuildingException;
import com.github.nicosensei.batch.elasticsearch.IndexBatch;
import com.github.nicosensei.batch.elasticsearch.IndexBatchState;
import com.github.nicosensei.batch.elasticsearch.IndexableDocument;
import com.github.nicosensei.batch.elasticsearch.SkipLimitExceededException;
import com.github.nicosensei.batch.input.InputLine;
import java.util.Collection;
import java.util.Map;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.xcontent.XContentBuilder;

public abstract class IndexWorker<I extends InputLine, D extends IndexableDocument>
extends Worker<I> {
    BatchExecutor executor = BatchExecutor.getInstance();
    private final TransportClient client;
    private final String indexName;
    private final String documentTypeName;

    protected IndexWorker(IndexBatch<I, D, ? extends IndexWorker<I, D>> batch, String documentTypeName) {
        super(batch.getInputFile(), (BatchState)batch.getBatchState());
        this.indexName = batch.getIndexName();
        this.documentTypeName = documentTypeName;
        this.client = batch.getElasticSearchClient();
    }

    public IndexBatchState getBatchState() {
        return (IndexBatchState)super.getBatchState();
    }

    protected abstract boolean canIngest(I var1) throws DocumentBuildingException;

    protected void processLine(I line) throws DocumentBuildingException {
        if (!this.canIngest(line)) {
            return;
        }
        this.buildBulkElement(line);
    }

    protected abstract void buildBulkElement(I var1) throws DocumentBuildingException;

    protected abstract Collection<D> getBulkContents();

    protected abstract void cleanBulkContents() throws BatchException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sectionComplete() throws BatchException {
        Collection<D> bulkContents = this.getBulkContents();
        if (bulkContents.isEmpty()) {
            return;
        }
        BulkRequestBuilder bulk = this.client.prepareBulk();
        for (IndexableDocument doc : bulkContents) {
            IndexRequestBuilder indexReqBuilder = this.client.prepareIndex(this.indexName, this.documentTypeName, doc.getDocumentId());
            switch (this.getDocumentSourceType()) {
                case documentAsMap: {
                    indexReqBuilder.setSource(this.getDocumentAsMap(doc));
                    break;
                }
                case xContentBuilder: {
                    indexReqBuilder.setSource(this.getDocumentContentBuilder(doc));
                }
            }
            bulk.add(indexReqBuilder);
        }
        IndexBatchState state = this.getBatchState();
        try {
            BulkResponse bulkResponse = (BulkResponse)bulk.execute().actionGet();
            if (bulkResponse.hasFailures()) {
                this.executor.logWarning(bulkResponse.buildFailureMessage());
                for (BulkItemResponse itemResp : bulkResponse.getItems()) {
                    if (!itemResp.isFailed()) continue;
                    if (state.getLinesSkipped() >= (long)IndexBatch.SKIP_LIMIT) {
                        throw new SkipLimitExceededException(IndexBatch.SKIP_LIMIT);
                    }
                    state.notifyLineSkipped();
                    this.executor.logWarning("Skipped item " + itemResp.toString());
                }
            }
        }
        finally {
            this.cleanBulkContents();
        }
    }

    protected void jobComplete() {
    }

    protected abstract DocumentSourceType getDocumentSourceType();

    protected abstract Map<String, Object> getDocumentAsMap(D var1) throws BatchException;

    protected abstract XContentBuilder getDocumentContentBuilder(D var1) throws BatchException;

    public static enum DocumentSourceType {
        documentAsMap,
        xContentBuilder;

    }
}

