/*
 * Decompiled with CFR 0.152.
 */
package com.github.nicosensei.batch.elasticsearch;

import com.github.nicosensei.batch.BatchExecutor;
import com.github.nicosensei.batch.ByteSizeBatchState;
import com.github.nicosensei.batch.elasticsearch.BatchInputReader;
import com.github.nicosensei.batch.input.InputLine;
import com.github.nicosensei.commons.utils.datatype.ByteCountFormatter;

public class IndexBatchState
extends ByteSizeBatchState
implements BatchInputReader.CooldownListener {
    private long linesProcessed = 0L;
    private boolean cooldown = false;
    private long linesSkipped = 0L;

    public IndexBatchState(String inputFilePath) {
        super(inputFilePath);
    }

    @Override
    public void handleCooldownEvent(boolean cooldown) {
        this.cooldown = cooldown;
    }

    public synchronized void notifyLineProcessed(InputLine line) {
        super.notifyLineProcessed(line);
        ++this.linesProcessed;
    }

    public synchronized void notifyLineSkipped() {
        ++this.linesSkipped;
    }

    public long getLinesSkipped() {
        return this.linesSkipped;
    }

    public void logStatus() {
        if (!this.cooldown) {
            int linesFailed = this.getErrors().length;
            BatchExecutor.getInstance().logInfo(this.linesProcessed + " lines - " + ByteCountFormatter.humanReadableByteCount((long)this.getUnitsProcessed()) + "/" + ByteCountFormatter.humanReadableByteCount((long)this.getUnitsToProcess()) + " processed (" + PERCENTAGE.format(this.getCompletionPercentage()) + "%)" + (this.linesSkipped > 0L ? " (" + this.linesSkipped + " skipped)" : "") + (linesFailed > 0 ? " (" + linesFailed + " failed)" : "") + ".");
        }
    }
}

