/*
 * Decompiled with CFR 0.152.
 */
package com.github.nicosensei.batch.elasticsearch;

import com.github.nicosensei.batch.Batch;
import com.github.nicosensei.batch.BatchException;
import com.github.nicosensei.batch.BatchExecutor;
import com.github.nicosensei.batch.elasticsearch.BatchInputReader;
import com.github.nicosensei.batch.elasticsearch.IndexBatchState;
import com.github.nicosensei.batch.elasticsearch.IndexCreationFailedException;
import com.github.nicosensei.batch.elasticsearch.IndexDeletionFailedException;
import com.github.nicosensei.batch.elasticsearch.IndexWorker;
import com.github.nicosensei.batch.elasticsearch.IndexableDocument;
import com.github.nicosensei.batch.input.InputFileException;
import com.github.nicosensei.batch.input.InputLine;
import java.util.HashMap;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexResponse;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;

public abstract class IndexBatch<I extends InputLine, D extends IndexableDocument, W extends IndexWorker<I, D>>
extends Batch<I, W> {
    private static final String ES_PING_TIMEOUT = BatchExecutor.getInstance().getProperty(IndexBatch.class, "esPingTimeout");
    private static final String[] ES_NODES_ADRESSES = BatchExecutor.getInstance().getProperty(IndexBatch.class, "esNodesAdresses").split(",");
    private static final String ES_CLUSTER_NAME = BatchExecutor.getInstance().getProperty(IndexBatch.class, "esClusterName");
    protected static final int SKIP_LIMIT = BatchExecutor.getInstance().getIntProperty(IndexBatch.class, "skipLimit", 1000);
    private TransportClient client;

    protected abstract W workerFactory() throws BatchException;

    protected IndexBatchState batchStateFactory() throws BatchException {
        IndexBatchState p = new IndexBatchState(this.getInputFilePath());
        this.getInputFile().addCooldownListener(p);
        return p;
    }

    public IndexBatchState getBatchState() {
        return (IndexBatchState)super.getBatchState();
    }

    protected final TransportClient getElasticSearchClient() {
        return this.client;
    }

    protected abstract String getIndexName();

    protected abstract BatchInputReader<I> inputFileReaderFactory() throws InputFileException;

    public BatchInputReader<I> getInputFile() {
        return (BatchInputReader)super.getInputFile();
    }

    protected abstract String getInputFilePath();

    protected abstract void specificInit(String[] var1) throws BatchException;

    protected final void init(String[] args) throws BatchException {
        this.specificInit(args);
        BatchExecutor executor = BatchExecutor.getInstance();
        HashMap<String, String> clientSettings = new HashMap<String, String>();
        clientSettings.put("cluster.name", ES_CLUSTER_NAME);
        if (ES_PING_TIMEOUT != null && !ES_PING_TIMEOUT.isEmpty()) {
            clientSettings.put("client.transport.ping_timeout", ES_PING_TIMEOUT);
        }
        executor.logInfo("Cluster name is '" + ES_CLUSTER_NAME + "'");
        this.client = new TransportClient((Settings.Builder)ImmutableSettings.settingsBuilder().put(clientSettings));
        for (String esta : ES_NODES_ADRESSES) {
            String[] parts = esta.split(":");
            this.client.addTransportAddress((TransportAddress)new InetSocketTransportAddress(parts[0], Integer.parseInt(parts[1])));
            executor.logInfo("Registered node address " + esta);
        }
        executor.logInfo("Target index name is " + this.getIndexName());
        if (this.initIndex()) {
            if (this.indexExists()) {
                executor.logInfo("Found existing index, will delete it.");
                this.deleteIndex();
            }
            this.createIndex();
        }
    }

    protected void onComplete() throws BatchException {
        BatchExecutor executor = BatchExecutor.getInstance();
        executor.logInfo("Will shut down ElasticSearch client...");
        this.client.close();
        executor.logInfo("... done!");
        IndexBatchState state = this.getBatchState();
        StringBuffer summary = new StringBuffer();
        summary.append("\n\t------------------------------------------------------------");
        summary.append("\n\t Summary");
        summary.append("\n\t------------------------------------------------------------");
        summary.append("\n\t- " + state.getProcessedLines() + " lines processed.");
        summary.append("\n\t- " + state.getErrors().length + " lines failed.");
        summary.append("\n\t- " + state.getLinesSkipped() + " lines skipped.");
        summary.append("\n\t------------------------------------------------------------");
        BatchExecutor.getInstance().logInfo(summary.toString());
    }

    protected abstract boolean initIndex();

    private boolean indexExists() {
        IndicesExistsResponse resp = (IndicesExistsResponse)this.getElasticSearchClient().admin().indices().prepareExists(new String[]{this.getIndexName()}).get();
        return resp.isExists();
    }

    private void deleteIndex() throws IndexDeletionFailedException {
        DeleteIndexResponse resp = (DeleteIndexResponse)this.getElasticSearchClient().admin().indices().prepareDelete(new String[]{this.getIndexName()}).get();
        if (!resp.isAcknowledged()) {
            throw new IndexDeletionFailedException(this.getIndexName());
        }
        BatchExecutor.getInstance().logInfo("Deleted index '" + this.getIndexName() + "'");
    }

    protected abstract String getCreateIndexSourceJSON();

    private void createIndex() throws IndexCreationFailedException {
        CreateIndexResponse resp = (CreateIndexResponse)this.getElasticSearchClient().admin().indices().prepareCreate(this.getIndexName()).setSource(this.getCreateIndexSourceJSON()).get();
        if (!resp.isAcknowledged()) {
            throw new IndexCreationFailedException(this.getIndexName());
        }
        BatchExecutor.getInstance().logInfo("Created index '" + this.getIndexName() + "'");
    }
}

