/*
 * Decompiled with CFR 0.152.
 */
package com.github.nicosensei.batch.elasticsearch;

import com.github.nicosensei.batch.BatchExecutor;
import com.github.nicosensei.batch.input.BigFileReader;
import com.github.nicosensei.batch.input.InputFileException;
import com.github.nicosensei.batch.input.InputLine;
import com.github.nicosensei.commons.utils.datatype.TimeFormatter;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;

public abstract class BatchInputReader<D extends InputLine>
extends BigFileReader<D> {
    private final long cooldownAfterLinesRead;
    private final int cooldownTimeInMillis;
    private long linesReadSinceCooldown = 0L;
    private List<CooldownListener> cooldownListeners = new ArrayList<CooldownListener>();

    public BatchInputReader(String inputFile, String inputFileEncoding, int sectionSize, boolean ignoreEmptyLines) throws InputFileException {
        super(inputFile, inputFileEncoding, sectionSize, ignoreEmptyLines);
        this.cooldownAfterLinesRead = 0L;
        this.cooldownTimeInMillis = 0;
    }

    public BatchInputReader(String inputFile, String inputFileEncoding, int sectionSize, boolean ignoreEmptyLines, long cooldownAfterLinesRead, int cooldownTimeInMillis) throws InputFileException {
        super(inputFile, inputFileEncoding, sectionSize, ignoreEmptyLines);
        this.cooldownAfterLinesRead = cooldownAfterLinesRead;
        this.cooldownTimeInMillis = cooldownTimeInMillis;
    }

    public void addCooldownListener(CooldownListener l) {
        this.cooldownListeners.add(l);
    }

    protected abstract D parseLine(String var1) throws InputFileException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String readOneLine() throws InputFileException {
        try {
            String string = super.readOneLine();
            return string;
        }
        finally {
            if (this.cooldownAfterLinesRead > 0L) {
                ++this.linesReadSinceCooldown;
                if (this.linesReadSinceCooldown >= this.cooldownAfterLinesRead) {
                    this.fireCooldownEvent(true);
                    BatchExecutor exec = BatchExecutor.getInstance();
                    try {
                        exec.logInfo("Input reader cooldown for " + TimeFormatter.formatDuration((long)this.cooldownTimeInMillis));
                        Thread.sleep(this.cooldownTimeInMillis);
                    }
                    catch (InterruptedException e) {
                        exec.logInfo(Thread.currentThread().getName() + " interrupted before colldown end!");
                    }
                    this.fireCooldownEvent(false);
                    this.linesReadSinceCooldown = 0L;
                }
            }
        }
    }

    private void fireCooldownEvent(boolean cooldown) {
        for (CooldownListener l : this.cooldownListeners) {
            l.handleCooldownEvent(cooldown);
        }
    }

    public static interface CooldownListener
    extends EventListener {
        public void handleCooldownEvent(boolean var1);
    }
}

