/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.rest;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Arrays;
import java.util.Set;
import java.util.TreeSet;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.ext.multipart.Attachment;
import org.apache.cxf.jaxrs.ext.multipart.AttachmentBuilder;
import org.apache.cxf.jaxrs.ext.multipart.ContentDisposition;
import org.apache.cxf.jaxrs.ext.multipart.MultipartBody;
import org.apache.cxf.transport.http.HTTPException;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MuleRest {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final Logger logger = LoggerFactory.getLogger(MuleRest.class);
    private static final String SNAPSHOT = "SNAPSHOT";
    private URL mmcUrl;
    private String username;
    private String password;

    public MuleRest(URL mmcUrl, String username, String password) {
        this.mmcUrl = mmcUrl;
        this.username = username;
        this.password = password;
        logger.debug("MMC URL: {}, Username: {}", (Object)mmcUrl, (Object)username);
    }

    private WebClient getWebClient(String ... paths) {
        WebClient webClient = WebClient.create((String)this.mmcUrl.toString(), (String)this.username, (String)this.password, null);
        for (String path : paths) {
            webClient.path((Object)path);
        }
        return webClient;
    }

    private String processResponse(Response response) throws IOException {
        int statusCode = response.getStatus();
        String responseObject = IOUtils.toString((InputStream)((InputStream)response.getEntity()));
        if (statusCode == Response.Status.OK.getStatusCode() || statusCode == Response.Status.CREATED.getStatusCode()) {
            return responseObject;
        }
        if (statusCode == Response.Status.NOT_FOUND.getStatusCode()) {
            HTTPException he = new HTTPException(statusCode, "The resource was not found.", this.mmcUrl);
            throw he;
        }
        if (statusCode == Response.Status.CONFLICT.getStatusCode()) {
            HTTPException he = new HTTPException(statusCode, "The operation was unsuccessful because a resource with that name already exists.", this.mmcUrl);
            throw he;
        }
        if (statusCode == Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()) {
            HTTPException he = new HTTPException(statusCode, "The operation was unsuccessful.", this.mmcUrl);
            throw he;
        }
        HTTPException he = new HTTPException(statusCode, "Unexpected Status Code Return, Status Line: " + statusCode, this.mmcUrl);
        throw he;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String restfullyCreateDeployment(String serverGroup, String name, String versionId) throws IOException {
        Set<String> serversIds = this.restfullyGetServers(serverGroup);
        if (serversIds.isEmpty()) {
            throw new IllegalArgumentException("No server found into group : " + serverGroup);
        }
        this.restfullyDeleteDeployment(name);
        WebClient webClient = this.getWebClient("deployments");
        webClient.type(MediaType.APPLICATION_JSON_TYPE);
        try {
            StringWriter stringWriter = new StringWriter();
            JsonFactory jfactory = new JsonFactory();
            JsonGenerator jGenerator = jfactory.createJsonGenerator((Writer)stringWriter);
            jGenerator.writeStartObject();
            jGenerator.writeStringField("name", name);
            jGenerator.writeFieldName("servers");
            jGenerator.writeStartArray();
            for (String serverId : serversIds) {
                jGenerator.writeString(serverId);
            }
            jGenerator.writeEndArray();
            jGenerator.writeFieldName("applications");
            jGenerator.writeStartArray();
            jGenerator.writeString(versionId);
            jGenerator.writeEndArray();
            jGenerator.writeEndObject();
            jGenerator.close();
            Response response = webClient.post((Object)stringWriter.toString());
            InputStream responseStream = (InputStream)response.getEntity();
            JsonNode jsonNode = OBJECT_MAPPER.readTree(responseStream);
            String string = jsonNode.path("id").asText();
            return string;
        }
        finally {
            webClient.close();
        }
    }

    public void restfullyDeleteDeployment(String name) throws IOException {
        String deploymentId = this.restfullyGetDeploymentIdByName(name);
        if (deploymentId != null) {
            this.restfullyDeleteDeploymentById(deploymentId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restfullyDeleteDeploymentById(String deploymentId) throws IOException {
        WebClient webClient = this.getWebClient("deployments", deploymentId);
        try {
            Response response = webClient.delete();
            this.processResponse(response);
        }
        finally {
            webClient.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restfullyDeployDeploymentById(String deploymentId) throws IOException {
        WebClient webClient = this.getWebClient("deployments", deploymentId, "deploy");
        try {
            Response response = webClient.post(null);
            this.processResponse(response);
        }
        finally {
            webClient.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String restfullyGetDeploymentIdByName(String name) throws IOException {
        WebClient webClient = this.getWebClient("deployments");
        String deploymentId = null;
        try {
            Response response = webClient.get();
            InputStream responseStream = (InputStream)response.getEntity();
            JsonNode jsonNode = OBJECT_MAPPER.readTree(responseStream);
            JsonNode deploymentsNode = jsonNode.path("data");
            for (JsonNode deploymentNode : deploymentsNode) {
                if (!name.equals(deploymentNode.path("name").asText())) continue;
                deploymentId = deploymentNode.path("id").asText();
                break;
            }
        }
        finally {
            webClient.close();
        }
        return deploymentId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String restfullyGetApplicationId(String name, String version) throws IOException {
        WebClient webClient = this.getWebClient("repository");
        String applicationId = null;
        try {
            Response response = webClient.get();
            InputStream responseStream = (InputStream)response.getEntity();
            JsonNode jsonNode = OBJECT_MAPPER.readTree(responseStream);
            JsonNode applicationsNode = jsonNode.path("data");
            block3: for (JsonNode applicationNode : applicationsNode) {
                if (!name.equals(applicationNode.path("name").asText())) continue;
                JsonNode versionsNode = applicationNode.path("versions");
                for (JsonNode versionNode : versionsNode) {
                    if (!version.equals(versionNode.path("name").asText())) continue;
                    applicationId = versionNode.get("id").asText();
                    continue block3;
                }
            }
        }
        finally {
            webClient.close();
        }
        return applicationId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String restfullyGetServerGroupId(String serverGroup) throws IOException {
        String serverGroupId = null;
        WebClient webClient = this.getWebClient("serverGroups");
        try {
            Response response = webClient.get();
            InputStream responseStream = (InputStream)response.getEntity();
            JsonNode jsonNode = OBJECT_MAPPER.readTree(responseStream);
            JsonNode groupsNode = jsonNode.path("data");
            for (JsonNode groupNode : groupsNode) {
                if (!serverGroup.equals(groupNode.path("name").asText())) continue;
                serverGroupId = groupNode.path("id").asText();
                break;
            }
            if (serverGroupId == null) {
                throw new IllegalArgumentException("no server group found having the name " + serverGroup);
            }
        }
        finally {
            webClient.close();
        }
        return serverGroupId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> restfullyGetServers(String serverGroup) throws IOException {
        TreeSet<String> serversId = new TreeSet<String>();
        WebClient webClient = this.getWebClient("servers");
        try {
            Response response = webClient.get();
            InputStream responseStream = (InputStream)response.getEntity();
            JsonNode jsonNode = OBJECT_MAPPER.readTree(responseStream);
            JsonNode serversNode = jsonNode.path("data");
            for (JsonNode serverNode : serversNode) {
                String serverId = serverNode.path("id").asText();
                JsonNode groupsNode = serverNode.path("groups");
                for (JsonNode groupNode : groupsNode) {
                    if (!serverGroup.equals(groupNode.path("name").asText())) continue;
                    serversId.add(serverId);
                }
            }
        }
        finally {
            webClient.close();
        }
        return serversId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String restfullyUploadRepository(String name, String version, File packageFile) throws IOException {
        WebClient webClient = this.getWebClient("repository");
        webClient.type("multipart/form-data");
        try {
            if (this.isSnapshotVersion(version)) {
                this.restfullyDeleteApplication(name, version);
            }
            Attachment nameAttachment = new AttachmentBuilder().id("name").object((Object)name).contentDisposition(new ContentDisposition("form-data; name=\"name\"")).build();
            Attachment versionAttachment = new AttachmentBuilder().id("version").object((Object)version).contentDisposition(new ContentDisposition("form-data; name=\"version\"")).build();
            Attachment fileAttachment = new Attachment("file", (InputStream)new FileInputStream(packageFile), new ContentDisposition("form-data; name=\"file\"; filename=\"" + packageFile.getName() + "\""));
            MultipartBody multipartBody = new MultipartBody(Arrays.asList(fileAttachment, nameAttachment, versionAttachment), MediaType.MULTIPART_FORM_DATA_TYPE, true);
            Response response = webClient.post((Object)multipartBody);
            String responseObject = this.processResponse(response);
            ObjectMapper mapper = new ObjectMapper();
            JsonNode result = mapper.readTree(responseObject);
            String string = result.path("versionId").asText();
            return string;
        }
        finally {
            webClient.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restfullyDeleteApplicationById(String applicationVersionId) throws IOException {
        WebClient webClient = this.getWebClient("repository", applicationVersionId);
        try {
            Response response = webClient.delete();
            this.processResponse(response);
        }
        finally {
            webClient.close();
        }
    }

    public void restfullyDeleteApplication(String applicationName, String version) throws IOException {
        String applicationVersionId = this.restfullyGetApplicationId(applicationName, version);
        if (applicationVersionId != null) {
            this.restfullyDeleteApplicationById(applicationVersionId);
        }
    }

    protected boolean isSnapshotVersion(String version) {
        return version.contains(SNAPSHOT);
    }
}

