/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.rest;

import java.io.File;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.mule.tools.maven.rest.MuleRest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.impl.StaticLoggerBinder;

public class Deploy
extends AbstractMojo {
    public static final String DEFAULT_NAME = "MuleApplication";
    protected File outputDirectory;
    protected String finalName;
    protected String name;
    protected String version;
    protected String username;
    protected String password;
    protected File appDirectory;
    protected URL muleApiUrl;
    protected String serverGroup;
    protected MuleRest muleRest;

    public void execute() throws MojoExecutionException, MojoFailureException {
        StaticLoggerBinder.getSingleton().setLog(this.getLog());
        Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
        if (this.name == null) {
            logger.info("Name is not set, using default \"{}\"", (Object)DEFAULT_NAME);
            this.name = DEFAULT_NAME;
        }
        if (this.version == null) {
            this.version = new SimpleDateFormat("MM-dd-yyyy-HH:mm:ss").format(Calendar.getInstance().getTime());
            logger.info("Version is not set, using a default of the timestamp: {}", (Object)this.version);
        }
        if (this.username == null || this.password == null) {
            throw new MojoFailureException((this.username == null ? "Username" : "Password") + " not set.");
        }
        if (this.outputDirectory == null) {
            throw new MojoFailureException("outputDirectory not set.");
        }
        if (this.finalName == null) {
            throw new MojoFailureException("finalName not set.");
        }
        if (this.serverGroup == null) {
            throw new MojoFailureException("serverGroup not set.");
        }
        try {
            this.validateProject(this.appDirectory);
            this.muleRest = this.buildMuleRest();
            String versionId = this.muleRest.restfullyUploadRepository(this.name, this.version, this.getMuleZipFile(this.outputDirectory, this.finalName));
            String deploymentId = this.muleRest.restfullyCreateDeployment(this.serverGroup, this.name, versionId);
            this.muleRest.restfullyDeployDeploymentById(deploymentId);
        }
        catch (Exception e) {
            throw new MojoFailureException("Error in attempting to deploy archive: " + e.toString(), (Throwable)e);
        }
    }

    protected File getMuleZipFile(File outputDirectory, String filename) throws MojoFailureException {
        File file = new File(outputDirectory, filename + ".zip");
        if (!file.exists()) {
            throw new MojoFailureException("There no application ZIP file generated : check that you have configured the maven-mule-plugin to generated the this file");
        }
        return file;
    }

    protected void validateProject(File appDirectory) throws MojoExecutionException {
        File muleConfig = new File(appDirectory, "mule-config.xml");
        File deploymentDescriptor = new File(appDirectory, "mule-deploy.properties");
        if (!muleConfig.exists() && !deploymentDescriptor.exists()) {
            throw new MojoExecutionException("No mule-config.xml or mule-deploy.properties");
        }
    }

    protected MuleRest buildMuleRest() {
        return new MuleRest(this.muleApiUrl, this.username, this.password);
    }
}

