/*
 * Decompiled with CFR 0.152.
 */
package com.github.ngeor.yak4j;

import com.github.ngeor.yak4j.BeanFiller;
import com.github.ngeor.yak4j.BeanUtils;
import com.github.ngeor.yak4j.BeanValueProvider;
import com.github.ngeor.yak4j.BuilderWithMapper;
import com.github.ngeor.yak4j.BuilderWithSourceClass;
import com.github.ngeor.yak4j.CompositeValueProvider;
import com.github.ngeor.yak4j.DefaultValueProvidersSupplier;
import com.github.ngeor.yak4j.ListMode;
import com.github.ngeor.yak4j.ListValueProvider;
import com.github.ngeor.yak4j.Options;
import com.github.ngeor.yak4j.ValueProvider;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;

public final class MappingTestHelper
implements BuilderWithMapper,
BuilderWithSourceClass {
    private final Object mapper;
    private Class<?> sourceClass;
    private Class<?> destinationClass;
    private String[] missingProperties;
    private Options options;
    private Supplier<ValueProvider[]> valueProvidersSupplier;

    MappingTestHelper(Object mapper) {
        this.mapper = mapper;
        this.missingProperties = new String[0];
        this.options = new Options();
        this.valueProvidersSupplier = new DefaultValueProvidersSupplier();
    }

    @Override
    public BuilderWithSourceClass canMap(Class<?> sourceClass) {
        this.sourceClass = sourceClass;
        return this;
    }

    @Override
    public BuilderWithSourceClass ignoringProperties(String ... missingProperties) {
        this.missingProperties = missingProperties;
        return this;
    }

    @Override
    public BuilderWithSourceClass withListMode(ListMode listMode) {
        this.options = this.options.withListMode(listMode);
        return this;
    }

    @Override
    public BuilderWithSourceClass withMaxRecursionDepth(int maxRecursionDepth) {
        this.options = this.options.withMaxRecursionDepth(maxRecursionDepth);
        return this;
    }

    @Override
    public BuilderWithSourceClass withValueProviders(Supplier<ValueProvider[]> valueProvidersSupplier) {
        this.valueProvidersSupplier = valueProvidersSupplier;
        return this;
    }

    @Override
    public void into(Class<?> destinationClass) throws ReflectiveOperationException {
        this.destinationClass = destinationClass;
        Object original = this.beanFiller().fillAllPropertiesWithRandomData(this.sourceClass.newInstance());
        Object copy = this.mapBackAndForth(original);
        for (String missingField : this.missingProperties) {
            ((ObjectAssert)Assertions.assertThat((Object)BeanUtils.getProperty(original, missingField)).withFailMessage("Property " + missingField + " should not be null in the original object", new Object[0])).isNotNull();
            ((ObjectAssert)Assertions.assertThat((Object)BeanUtils.getProperty(copy, missingField)).withFailMessage("Property " + missingField + " should be null in the copy object", new Object[0])).isNull();
            BeanUtils.setProperty(original, missingField, null);
        }
        Assertions.assertThat(copy).isEqualToComparingFieldByFieldRecursively(original);
    }

    private List<String> getPackagesWithMappedClasses() {
        return Stream.of(this.sourceClass, this.destinationClass).map(c -> c.getPackage().getName()).collect(Collectors.toList());
    }

    public static BuilderWithMapper assertThatMapper(Object mapper) {
        return new MappingTestHelper(mapper);
    }

    private BeanFiller beanFiller() {
        CompositeValueProvider compositeResolver = new CompositeValueProvider();
        BeanFiller beanFiller = new BeanFiller(this.options.getMaxRecursionDepth(), compositeResolver);
        List<ValueProvider> valueProviders = Stream.concat(Stream.of((Object[])this.valueProvidersSupplier.get()), Stream.of(new ListValueProvider(this.options, compositeResolver), new BeanValueProvider(beanFiller, this.getPackagesWithMappedClasses()))).collect(Collectors.toList());
        compositeResolver.setValueProviders(valueProviders);
        return beanFiller;
    }

    private static Object map(Object mapper, Object source, Class<?> sourceClass, Class<?> destinationClass) throws InvocationTargetException, IllegalAccessException {
        List methods = Arrays.stream(mapper.getClass().getMethods()).filter(m -> m.getReturnType().equals(destinationClass)).filter(m -> m.getParameterCount() == 1).filter(m -> m.getParameterTypes()[0].equals(sourceClass)).collect(Collectors.toList());
        ((AbstractIntegerAssert)Assertions.assertThat((int)methods.size()).withFailMessage("Expecting exactly one mapping method %s -> %s, found: %d", new Object[]{sourceClass, destinationClass, methods.size()})).isEqualTo(1);
        Method method = (Method)methods.get(0);
        return method.invoke(mapper, source);
    }

    private <T> T mapBackAndForth(T source) throws InvocationTargetException, IllegalAccessException {
        Object mapped = MappingTestHelper.map(this.mapper, source, this.sourceClass, this.destinationClass);
        return (T)MappingTestHelper.map(this.mapper, mapped, this.destinationClass, this.sourceClass);
    }
}

