/*
 * Decompiled with CFR 0.152.
 */
package com.github.ngeor.yak4j;

import com.github.ngeor.yak4j.BeanUtils;
import com.github.ngeor.yak4j.CompositeValueProvider;
import com.github.ngeor.yak4j.Options;
import com.github.ngeor.yak4j.ValueProvider;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

class ListValueProvider
implements ValueProvider {
    private final Options options;
    private final CompositeValueProvider childValueProvider;

    ListValueProvider(Options options, CompositeValueProvider childValueProvider) {
        this.options = options;
        this.childValueProvider = childValueProvider;
    }

    @Override
    public boolean canProvide(Class<?> parameterClass) {
        return List.class.equals(parameterClass);
    }

    @Override
    public Object provide(Class<?> parameterClass, Method setterMethod) throws IllegalAccessException, InvocationTargetException, InstantiationException {
        switch (this.options.getListMode()) {
            case Null: {
                return null;
            }
            case Empty: {
                return Collections.emptyList();
            }
            case NullItem: {
                return Collections.singletonList(null);
            }
            case Recursive: {
                Class genericClass = (Class)Optional.ofNullable(setterMethod).map(Method::getGenericParameterTypes).map(ListValueProvider::first).map(ListValueProvider::castToParameterizedType).map(ParameterizedType::getActualTypeArguments).map(ListValueProvider::first).map(Type::getTypeName).flatMap(BeanUtils::classForName).orElseThrow(() -> new IllegalArgumentException("Could not find generic class for list"));
                return Collections.singletonList(this.childValueProvider.provide(genericClass, setterMethod));
            }
        }
        throw new UnsupportedOperationException("Unknown list mode " + (Object)((Object)this.options.getListMode()));
    }

    private static Type first(Type[] types) {
        return types != null && types.length > 0 ? types[0] : null;
    }

    private static ParameterizedType castToParameterizedType(Type type) {
        return type instanceof ParameterizedType ? (ParameterizedType)type : null;
    }
}

