/*
 * Decompiled with CFR 0.152.
 */
package com.github.ngeor.yak4j;

import com.github.ngeor.yak4j.BeanFiller;
import com.github.ngeor.yak4j.ValueProvider;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;

class BeanValueProvider
implements ValueProvider {
    private final BeanFiller beanFiller;
    private final List<String> packagesWithMappedClasses;

    BeanValueProvider(BeanFiller beanFiller, List<String> packagesWithMappedClasses) {
        this.beanFiller = beanFiller;
        this.packagesWithMappedClasses = packagesWithMappedClasses;
    }

    @Override
    public boolean canProvide(Class<?> parameterClass) {
        return this.packagesWithMappedClasses.stream().anyMatch(p -> this.packageStartsWith(parameterClass, (String)p));
    }

    @Override
    public Object provide(Class<?> parameterClass, Method setterMethod) throws InvocationTargetException, IllegalAccessException, InstantiationException {
        Object newInstance = parameterClass.newInstance();
        return this.beanFiller.fillAllPropertiesWithRandomData(newInstance);
    }

    private boolean packageStartsWith(Class<?> parameterClass, String prefix) {
        return Optional.of(parameterClass).flatMap(p -> Optional.ofNullable(p.getPackage())).map(Package::getName).filter(p -> p.startsWith(prefix)).isPresent();
    }
}

