/*
 * Decompiled with CFR 0.152.
 */
package com.github.ngeor.yak4j;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public final class BeanUtils {
    private BeanUtils() {
    }

    public static Method getGetter(Object object, String field) throws NoSuchMethodException {
        return object.getClass().getMethod("get" + StringUtils.capitalize((String)field), new Class[0]);
    }

    public static Object getProperty(Object object, String field) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        return BeanUtils.getGetter(object, field).invoke(object, new Object[0]);
    }

    public static Method getSetter(Object object, String field) throws NoSuchMethodException {
        Method getter = BeanUtils.getGetter(object, field);
        return object.getClass().getMethod("set" + StringUtils.capitalize((String)field), getter.getReturnType());
    }

    public static void setProperty(Object object, String field, Object value) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        BeanUtils.getSetter(object, field).invoke(object, value);
    }

    public static boolean isSetter(Method method) {
        return method.getName().startsWith("set") && method.getParameterCount() == 1;
    }

    public static Optional<Class> classForName(String name) {
        try {
            return Optional.ofNullable(Class.forName(name));
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return Optional.empty();
        }
    }
}

