/*
 * Decompiled with CFR 0.152.
 */
package com.github.ngeor.yak4j;

import com.github.ngeor.yak4j.BeanUtils;
import com.github.ngeor.yak4j.CompositeValueProvider;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.stream.Stream;

class BeanFiller {
    private final int maximumRecursionDepth;
    private final CompositeValueProvider propertyValueProvider;

    BeanFiller(int maximumRecursionDepth, CompositeValueProvider propertyValueProvider) {
        this.maximumRecursionDepth = maximumRecursionDepth;
        this.propertyValueProvider = propertyValueProvider;
    }

    <T> T fillAllPropertiesWithRandomData(T object) throws InvocationTargetException, IllegalAccessException, InstantiationException {
        if (this.getCurrentRecursionDepth() > (long)this.maximumRecursionDepth) {
            return null;
        }
        Class<?> aClass = object.getClass();
        Stream<Method> setters = Arrays.stream(aClass.getMethods()).filter(BeanUtils::isSetter);
        for (Method method : setters::iterator) {
            this.callSetter(object, method);
        }
        return object;
    }

    private long getCurrentRecursionDepth() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        String caller = stackTrace[2].getMethodName();
        return Arrays.stream(stackTrace).filter(s -> s.getMethodName().equals(caller)).count() - 1L;
    }

    private void callSetter(Object object, Method method) throws InvocationTargetException, IllegalAccessException, InstantiationException {
        method.invoke(object, this.resolveValue(method));
    }

    private Object resolveValue(Method setterMethod) throws IllegalAccessException, InvocationTargetException, InstantiationException {
        Class<?> parameterClass = setterMethod.getParameterTypes()[0];
        return this.propertyValueProvider.provide(parameterClass, setterMethod);
    }
}

