/*
 * Decompiled with CFR 0.152.
 */
package ec.util.spreadsheet.xmlss;

import ec.util.spreadsheet.helpers.ArraySheet;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

abstract class XmlssSheetBuilder {
    XmlssSheetBuilder() {
    }

    public abstract @NonNull XmlssSheetBuilder put(@Nullable String var1, @Nullable String var2, int var3, int var4);

    public abstract @NonNull XmlssSheetBuilder name(@NonNull String var1);

    public abstract @NonNull XmlssSheetBuilder clear();

    public abstract @NonNull ArraySheet build();

    public static @NonNull XmlssSheetBuilder create() {
        return new Builder();
    }

    private static final class Builder
    extends XmlssSheetBuilder {
        private final DateFormat dateFormat;
        private final NumberFormat numberFormat = NumberFormat.getNumberInstance(Locale.ROOT);
        private final ArraySheet.Builder sheetDataBuilder;

        public Builder() {
            this.numberFormat.setMaximumFractionDigits(9);
            this.numberFormat.setMaximumIntegerDigits(12);
            this.dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            this.sheetDataBuilder = ArraySheet.builder();
        }

        private Object getCellValue(String rawValue, String rawDataType) {
            switch (rawDataType) {
                case "String": {
                    return rawValue;
                }
                case "Number": {
                    try {
                        return this.numberFormat.parse(rawValue);
                    }
                    catch (ParseException ex) {
                        return null;
                    }
                }
                case "DateTime": {
                    try {
                        return this.dateFormat.parse(rawValue);
                    }
                    catch (ParseException ex) {
                        return null;
                    }
                }
            }
            return null;
        }

        private boolean isNullOrEmpty(String s) {
            return s == null || s.isEmpty();
        }

        @Override
        public Builder put(String rawValue, String rawDataType, int row, int col) {
            if (this.isNullOrEmpty(rawValue) || this.isNullOrEmpty(rawDataType)) {
                return this;
            }
            Object cellValue = this.getCellValue(rawValue, rawDataType);
            if (cellValue == null) {
                return this;
            }
            this.sheetDataBuilder.value(row, col, cellValue);
            return this;
        }

        @Override
        public Builder name(String name) {
            this.sheetDataBuilder.name(name);
            return this;
        }

        @Override
        public Builder clear() {
            this.sheetDataBuilder.clear();
            return this;
        }

        @Override
        public ArraySheet build() {
            return this.sheetDataBuilder.build();
        }
    }
}

