/*
 * Decompiled with CFR 0.152.
 */
package ec.util.spreadsheet.xmlss;

import ec.util.spreadsheet.Book;
import ec.util.spreadsheet.Sheet;
import ec.util.spreadsheet.xmlss.BasicXmlssWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Date;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.checkerframework.checker.nullness.qual.NonNull;
import shaded.spreadsheet.nbbrd.io.xml.Stax;

final class XmlssBookWriter {
    private final XMLOutputFactory xof;
    private final Charset charset;

    public XmlssBookWriter(@NonNull XMLOutputFactory xof, @NonNull Charset charset) {
        this.xof = xof;
        this.charset = charset;
    }

    public void write(@NonNull OutputStream stream, @NonNull Book book) throws IOException {
        Stax.StreamFormatter.builder().factory(() -> this.xof).encoding(this.charset).handler(XmlssBookWriter::write).build().formatStream((Object)book, stream);
    }

    private static void write(Book book, XMLStreamWriter w) throws IOException, XMLStreamException {
        XmlssBookWriter.write(new BasicXmlssWriter(w), book);
    }

    private static void write(BasicXmlssWriter f, Book book) throws IOException, XMLStreamException {
        f.beginWorkbook();
        int sheetCount = book.getSheetCount2();
        for (int s = 0; s < sheetCount; ++s) {
            XmlssBookWriter.write(f, book.getSheet(s));
        }
        f.endWorkbook();
    }

    private static void write(BasicXmlssWriter f, Sheet sheet) throws XMLStreamException {
        f.beginWorksheet(sheet.getName());
        f.beginTable();
        int rowCount = sheet.getRowCount();
        int columnCount = sheet.getColumnCount();
        for (int i = 0; i < rowCount; ++i) {
            f.beginRow();
            for (int j = 0; j < columnCount; ++j) {
                XmlssBookWriter.writeCellValue(f, sheet.getCellValue(i, j));
            }
            f.endRow();
        }
        f.endTable();
        f.endWorksheet();
    }

    private static void writeCellValue(BasicXmlssWriter f, Object cellValue) throws XMLStreamException {
        if (cellValue != null) {
            if (cellValue instanceof Date) {
                f.writeCell((Date)cellValue);
            } else if (cellValue instanceof Number) {
                f.writeCell(((Number)cellValue).doubleValue());
            } else if (cellValue instanceof String) {
                f.writeCell((String)cellValue);
            }
        } else {
            f.writeCell();
        }
    }
}

