/*
 * Decompiled with CFR 0.152.
 */
package ec.util.spreadsheet.xmlss;

import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

final class BasicXmlssWriter {
    private final XMLStreamWriter writer;
    private final NumberFormat numberFormat;
    private final DateFormat dateFormat;
    private int cellIndex;
    private boolean needIndex;

    public BasicXmlssWriter(XMLStreamWriter writer) {
        this.writer = writer;
        this.numberFormat = NumberFormat.getNumberInstance(Locale.ROOT);
        this.numberFormat.setMaximumFractionDigits(9);
        this.numberFormat.setMaximumIntegerDigits(12);
        this.dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    }

    public void beginWorkbook() throws XMLStreamException {
        this.writer.writeStartDocument();
        this.writer.writeProcessingInstruction("mso-application", "progid=\"Excel.Sheet\"");
        this.writer.writeStartElement("Workbook");
        this.writer.writeAttribute("xmlns", "urn:schemas-microsoft-com:office:spreadsheet");
        this.writer.writeAttribute("xmlns:o", "urn:schemas-microsoft-com:office:office");
        this.writer.writeAttribute("xmlns:x", "urn:schemas-microsoft-com:office:excel");
        this.writer.writeAttribute("xmlns:ss", "urn:schemas-microsoft-com:office:spreadsheet");
        this.writer.writeAttribute("xmlns:html", "http://www.w3.org/TR/REC-html40");
        this.writer.writeStartElement("Styles");
        this.writer.writeStartElement("Style");
        this.writer.writeAttribute("ss:ID", "s24");
        this.writer.writeStartElement("NumberFormat");
        this.writer.writeAttribute("ss:Format", "Short Date");
        this.writer.writeEndElement();
        this.writer.writeEndElement();
        this.writer.writeEndElement();
    }

    public void endWorkbook() throws XMLStreamException {
        this.writer.writeEndElement();
        this.writer.writeEndDocument();
        this.writer.flush();
    }

    public void beginWorksheet(String name) throws XMLStreamException {
        this.writer.writeStartElement("Worksheet");
        this.writer.writeAttribute("ss:Name", name);
    }

    public void endWorksheet() throws XMLStreamException {
        this.writer.writeEndElement();
        this.writer.flush();
    }

    public void beginTable() throws XMLStreamException {
        this.writer.writeStartElement("Table");
    }

    public void endTable() throws XMLStreamException {
        this.writer.writeEndElement();
    }

    public void beginRow() throws XMLStreamException {
        this.writer.writeStartElement("Row");
        this.cellIndex = 0;
        this.needIndex = false;
    }

    public void endRow() throws XMLStreamException {
        this.writer.writeEndElement();
    }

    public void writeCell(Date date) throws XMLStreamException {
        ++this.cellIndex;
        this.writer.writeStartElement("Cell");
        if (this.needIndex) {
            this.writer.writeAttribute("ss:Index", Integer.toString(this.cellIndex));
        }
        this.writer.writeAttribute("ss:StyleID", "s24");
        this.writer.writeStartElement("Data");
        this.writer.writeAttribute("ss:Type", "DateTime");
        String sd = this.dateFormat.format(date);
        this.writer.writeCharacters(sd);
        this.writer.writeEndElement();
        this.writer.writeEndElement();
        this.needIndex = false;
    }

    public void writeCell(double val) throws XMLStreamException {
        ++this.cellIndex;
        this.writer.writeStartElement("Cell");
        if (this.needIndex) {
            this.writer.writeAttribute("ss:Index", Integer.toString(this.cellIndex));
        }
        this.writer.writeStartElement("Data");
        if (!Double.isNaN(val)) {
            this.writer.writeAttribute("ss:Type", "Number");
            this.writer.writeCharacters(this.numberFormat.format(val));
        } else {
            this.writer.writeAttribute("ss:Type", "String");
            this.writer.writeCharacters("");
        }
        this.writer.writeEndElement();
        this.writer.writeEndElement();
        this.needIndex = false;
    }

    public void writeCell(String txt) throws XMLStreamException {
        ++this.cellIndex;
        this.writer.writeStartElement("Cell");
        if (this.needIndex) {
            this.writer.writeAttribute("ss:Index", Integer.toString(this.cellIndex));
        }
        this.writer.writeStartElement("Data");
        this.writer.writeAttribute("ss:Type", "String");
        this.writer.writeCharacters(txt != null ? txt : "");
        this.writer.writeEndElement();
        this.writer.writeEndElement();
        this.needIndex = false;
    }

    public void writeCell() {
        ++this.cellIndex;
        this.needIndex = true;
    }
}

