/*
 * Decompiled with CFR 0.152.
 */
package sdmxdl.util.web;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;
import sdmxdl.util.web.CachedWebClient;
import sdmxdl.util.web.SdmxWebClient;
import sdmxdl.util.web.SdmxWebConnectionImpl;
import sdmxdl.util.web.SdmxWebProperty;
import sdmxdl.web.SdmxWebConnection;
import sdmxdl.web.SdmxWebSource;
import sdmxdl.web.spi.SdmxWebContext;
import sdmxdl.web.spi.SdmxWebDriver;

public final class SdmxWebDriverSupport
implements SdmxWebDriver {
    @NonNull
    private final String name;
    private final int rank;
    @NonNull
    private final SdmxWebClient.Supplier client;
    private final Collection<SdmxWebSource> sources;
    private final Collection<String> supportedProperties;

    public SdmxWebConnection connect(SdmxWebSource source, SdmxWebContext context) throws IOException {
        Objects.requireNonNull(source);
        Objects.requireNonNull(context);
        SdmxWebDriverSupport.checkSource(source, this.name);
        return SdmxWebConnectionImpl.of(this.getClient(source, context), this.name);
    }

    public Collection<SdmxWebSource> getDefaultSources() {
        return this.sources;
    }

    public Collection<String> getSupportedProperties() {
        return this.supportedProperties;
    }

    private SdmxWebClient getClient(SdmxWebSource source, SdmxWebContext context) throws IOException {
        return CachedWebClient.of(this.client.get(source, context), context.getCache(), SdmxWebProperty.CACHE_TTL_PROPERTY.get(source.getProperties()), source, context.getLanguages());
    }

    public static void checkSource(@org.checkerframework.checker.nullness.qual.NonNull SdmxWebSource source, @org.checkerframework.checker.nullness.qual.NonNull String name) throws IllegalArgumentException {
        if (!source.getDriver().equals(name)) {
            throw new IllegalArgumentException(source.toString());
        }
    }

    @Generated
    private static int $default$rank() {
        return -1;
    }

    @Generated
    SdmxWebDriverSupport(@NonNull String name, int rank, @NonNull SdmxWebClient.Supplier client, Collection<SdmxWebSource> sources, Collection<String> supportedProperties) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        this.name = name;
        this.rank = rank;
        this.client = client;
        this.sources = sources;
        this.supportedProperties = supportedProperties;
    }

    @Generated
    public static @org.checkerframework.checker.nullness.qual.NonNull Builder builder() {
        return new Builder();
    }

    @Generated
    public @org.checkerframework.checker.nullness.qual.NonNull Builder toBuilder() {
        Builder builder = new Builder().name(this.name).rank(this.rank).client(this.client);
        if (this.sources != null) {
            builder.sources(this.sources);
        }
        if (this.supportedProperties != null) {
            builder.supportedProperties(this.supportedProperties);
        }
        return builder;
    }

    @NonNull
    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public int getRank() {
        return this.rank;
    }

    public static final class Builder {
        @Generated
        private String name;
        @Generated
        private boolean rank$set;
        @Generated
        private int rank$value;
        @Generated
        private SdmxWebClient.Supplier client;
        @Generated
        private ArrayList<SdmxWebSource> sources;
        @Generated
        private ArrayList<String> supportedProperties;

        public @org.checkerframework.checker.nullness.qual.NonNull Builder supportedPropertyOf(@org.checkerframework.checker.nullness.qual.NonNull CharSequence property) {
            return this.supportedProperty(property.toString());
        }

        @Generated
        Builder() {
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Builder name(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return this;
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Builder rank(int rank) {
            this.rank$value = rank;
            this.rank$set = true;
            return this;
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Builder client(@NonNull SdmxWebClient.Supplier client) {
            if (client == null) {
                throw new NullPointerException("client is marked non-null but is null");
            }
            this.client = client;
            return this;
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Builder source(SdmxWebSource source) {
            if (this.sources == null) {
                this.sources = new ArrayList();
            }
            this.sources.add(source);
            return this;
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Builder sources(@org.checkerframework.checker.nullness.qual.NonNull Collection<? extends SdmxWebSource> sources) {
            if (sources == null) {
                throw new NullPointerException("sources cannot be null");
            }
            if (this.sources == null) {
                this.sources = new ArrayList();
            }
            this.sources.addAll(sources);
            return this;
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Builder clearSources() {
            if (this.sources != null) {
                this.sources.clear();
            }
            return this;
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Builder supportedProperty(String supportedProperty) {
            if (this.supportedProperties == null) {
                this.supportedProperties = new ArrayList();
            }
            this.supportedProperties.add(supportedProperty);
            return this;
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Builder supportedProperties(@org.checkerframework.checker.nullness.qual.NonNull Collection<? extends String> supportedProperties) {
            if (supportedProperties == null) {
                throw new NullPointerException("supportedProperties cannot be null");
            }
            if (this.supportedProperties == null) {
                this.supportedProperties = new ArrayList();
            }
            this.supportedProperties.addAll(supportedProperties);
            return this;
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull Builder clearSupportedProperties() {
            if (this.supportedProperties != null) {
                this.supportedProperties.clear();
            }
            return this;
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull SdmxWebDriverSupport build() {
            List<String> supportedProperties;
            List<SdmxWebSource> sources;
            switch (this.sources == null ? 0 : this.sources.size()) {
                case 0: {
                    sources = Collections.emptyList();
                    break;
                }
                case 1: {
                    sources = Collections.singletonList(this.sources.get(0));
                    break;
                }
                default: {
                    sources = Collections.unmodifiableList(new ArrayList<SdmxWebSource>(this.sources));
                }
            }
            switch (this.supportedProperties == null ? 0 : this.supportedProperties.size()) {
                case 0: {
                    supportedProperties = Collections.emptyList();
                    break;
                }
                case 1: {
                    supportedProperties = Collections.singletonList(this.supportedProperties.get(0));
                    break;
                }
                default: {
                    supportedProperties = Collections.unmodifiableList(new ArrayList<String>(this.supportedProperties));
                }
            }
            int rank$value = this.rank$value;
            if (!this.rank$set) {
                rank$value = SdmxWebDriverSupport.$default$rank();
            }
            return new SdmxWebDriverSupport(this.name, rank$value, this.client, sources, supportedProperties);
        }

        @Generated
        public @org.checkerframework.checker.nullness.qual.NonNull String toString() {
            return "SdmxWebDriverSupport.Builder(name=" + this.name + ", rank$value=" + this.rank$value + ", client=" + this.client + ", sources=" + this.sources + ", supportedProperties=" + this.supportedProperties + ")";
        }
    }
}

