/*
 * Decompiled with CFR 0.152.
 */
package sdmxdl.util.web;

import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;
import nbbrd.io.function.IORunnable;
import sdmxdl.DataCursor;
import sdmxdl.DataFilter;
import sdmxdl.DataStructure;
import sdmxdl.DataStructureRef;
import sdmxdl.Dataflow;
import sdmxdl.DataflowRef;
import sdmxdl.Key;
import sdmxdl.Series;
import sdmxdl.ext.SdmxExceptions;
import sdmxdl.util.web.DataRequest;
import sdmxdl.util.web.SdmxWebClient;
import sdmxdl.web.SdmxWebConnection;

final class SdmxWebConnectionImpl
implements SdmxWebConnection {
    @NonNull
    private final SdmxWebClient client;
    @NonNull
    private final String driver;
    private boolean closed = false;

    public Collection<Dataflow> getFlows() throws IOException {
        this.checkState();
        return this.client.getFlows();
    }

    public Dataflow getFlow(DataflowRef flowRef) throws IOException {
        this.checkState();
        return this.client.getFlow(flowRef);
    }

    public DataStructure getStructure(DataflowRef flowRef) throws IOException {
        this.checkState();
        DataStructureRef structRef = this.client.peekStructureRef(flowRef);
        if (structRef == null) {
            Dataflow flow = this.client.getFlow(flowRef);
            structRef = flow.getStructureRef();
        }
        return this.client.getStructure(structRef);
    }

    public List<Series> getData(DataflowRef flowRef, Key key, DataFilter filter) throws IOException {
        try (DataCursor cursor = this.getDataCursor(flowRef, key, filter);){
            List<Series> list = cursor.toStream().collect(Collectors.toList());
            return list;
        }
    }

    public Stream<Series> getDataStream(DataflowRef flowRef, Key key, DataFilter filter) throws IOException {
        DataCursor cursor = this.getDataCursor(flowRef, key, filter);
        return (Stream)cursor.toStream().onClose(IORunnable.unchecked(() -> cursor.close()));
    }

    public DataCursor getDataCursor(DataflowRef flowRef, Key key, DataFilter filter) throws IOException {
        this.checkState();
        DataStructureRef structRef = this.client.peekStructureRef(flowRef);
        if (structRef == null) {
            Dataflow flow = this.client.getFlow(flowRef);
            structRef = flow.getStructureRef();
            flowRef = flow.getRef();
        }
        DataStructure structure = this.client.getStructure(structRef);
        return this.isDetailSupported() ? this.client.getData(new DataRequest(flowRef, key, filter), structure) : this.client.getData(new DataRequest(flowRef, key, DataFilter.FULL), structure).filter(key, filter);
    }

    public boolean isDetailSupported() throws IOException {
        return this.client.isDetailSupported();
    }

    public Duration ping() throws IOException {
        this.checkState();
        return this.client.ping();
    }

    public String getDriver() throws IOException {
        this.checkState();
        return this.driver;
    }

    public void close() {
        this.closed = true;
    }

    private void checkState() throws IOException {
        if (this.closed) {
            throw SdmxExceptions.connectionClosed((String)this.client.getName());
        }
    }

    @Generated
    private SdmxWebConnectionImpl(@NonNull SdmxWebClient client, @NonNull String driver) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (driver == null) {
            throw new NullPointerException("driver is marked non-null but is null");
        }
        this.client = client;
        this.driver = driver;
    }

    @Generated
    public static @org.checkerframework.checker.nullness.qual.NonNull SdmxWebConnectionImpl of(@NonNull SdmxWebClient client, @NonNull String driver) {
        return new SdmxWebConnectionImpl(client, driver);
    }
}

